
*--------------------------------------------------------------------------------*
*
*   Original code: http://support.sas.com/sassamples/quicktips/0206contents.html
*
*--------------------------------------------------------------------------------*;

*-------------------------------------*
* %macro checkver checks the current  *
* version of SAS and creates the      *
* macro variable &var, which contains *
* the current name of one of the ODS  *
* output objects below.               *
*-------------------------------------*;

%macro checkver;
%global var;
  %if &sysver lt 9 %then %let var=VariablesAlpha;
  %else %if &sysver ge 9 %then %let var=Variables; 
%mend checkver;
%checkver;


%macro contents(data);
  *-------------------------------------*
  * Use the ODS OUTPUT statement to     *
  * specify data sets to which CONTENTS *
  * data will be directed.              *
  *-------------------------------------*;

  ods output &var=var;
           
  *----------------------------------------*
  * Temporarily suppress output to the lst.*
  *----------------------------------------*;           
  ods listing close;

  proc contents data=&data;run;

  *----------------------------------------*
  * Resume output to the lst.              *
  *----------------------------------------*;

  ods listing;

  title "Data Set Contents";
  proc print data=var noobs;run;
  
%mend;
