# ------- Do not edit this file ------------------------------------------------
#
# Version 1.4.1
# Released July 2015
# http://www.medicine.mcgill.ca/epidemiology/Joseph/PBelisle/loop.html
# ------------------------------------------------------------------------------

use strict;
use Win32;

our ($LogFile, $MyStartTime);
&OpenSTDERR($0, 1);

# ------------------------------------------------------------------------------
my @pgms;
our %value;

# ------------------------------------------------------------------------------

foreach (@ARGV)
{
  next unless -f;

  my $file = Win32::GetFullPathName($_);
  push(@pgms, $file);
}

die "No input file given. Abort.\n" unless @pgms;

# ------------------------------------------------------------------------------
my %Default = (brackets           => "<>",
               comment            => "#",
               ext                => "txt",
               keepleadingblanks  => 0,
               keeptrailingblanks => 0,
               width              => 120);



# ------------------------------------------------------------------------------


foreach my $pgm (@pgms)
{
  my ($linkProblem, $K, $parmno,
      @beforebracket, @code,
      %i, %k, %linked2, %nvalues, %option, %parmno, %script);

  # reset %option
  foreach (keys %Default)
  {
    $option{$_} = $Default{$_};
  }


  # Read pgm to edit

  unless (-r $pgm)
  {
    print STDERR "Cannot read input file $pgm\nSorry.\n\n";
    next;
  }

  open(PGM, $pgm);
  my @pgm0 = (<PGM>);
  close PGM;


  # Remove comments and blank lines on top of file

  while (@pgm0)
  {
    $_ = shift @pgm0;
    next if /\s*#/ && !$`;

    if (/\S/)
    {
      unshift(@pgm0, $_);
      last;
    }
  }


  # Extract Loop instructions from top of file ---

  while (@pgm0)
  {
    $_ = shift @pgm0;
    last if /\s*}\s*/ && !$` && !$';

    chomp;
    push(@code, $_);
  }


  unless (@pgm0)
  {
    print STDERR "Nothing to loop over in file $pgm\nSorry\n\n";
    next;
  }


  shift @code until $code[0] =~ /\S/ || !@code;


  while (@code)
  {
    $_ = shift @code;
    last if /\s*\{\s*/ && !$` && !$';

    push(@beforebracket, $_) if /\S/;
  }


  my ($dir) = Win32::GetFullPathName($pgm);
  chdir($dir);

  # Read options and output file(s) location from header
  my $tmp = pop @beforebracket;
  $tmp =~ s/^\s+|\s+$//g; # lrtrim


  if ($tmp =~ /"([^"]*)"\s*/ && !$`)
  {
    ($tmp, $option{script}) = ($', $1);
  }
  else
  {
    $tmp =~ /(\S+)\s*/;
    ($tmp, $option{script}) = ($', $1);
  }


  unless ($option{script})
  {
    print STDERR "Output file destination not specified in $pgm\nSorry\n\n";
    next;
  }


  while ($tmp =~ /\S+/)
  {
    my $option = lc $&;

    $tmp = $';
    $tmp =~ s/\s*(.*)/\1/;  # ltrim

    if ($option eq "-nosep")
    {
      $option{nosep} = 1;
    }
    elsif ($option eq "-b")
    {
      $tmp =~ /\S+/;
      ($option{brackets}, $tmp) = ($&, $');
      $tmp =~ s/\s*(.*)/\1/;  # ltrim

      unless (length($option{brackets}) == 2)
      {
        print STDERR "Argument following $option must be of length 2 (in $pgm)\nSorry.\n\n";
        $option{error} = 1;
      }
    }
    elsif ($option eq "-blanksep")
    {
      $option{width} = 0;
    }
    elsif ($option eq "-c")
    {
      $tmp =~ /\S+/;
      ($option{comment}, $tmp) = ($&, $');
      $tmp =~ s/\s*(.*)/\1/;  # ltrim
    }
    elsif ($option eq "-klb" || $option eq "-plb")
    {
      $option{keepleadingblanks} = 1;
    }
    elsif ($option eq "-ktb" || $option eq "-ptb")
    {
      $option{keeptrailingblanks} = 1;
    }
    elsif ($option eq "-m")
    {
      $option{multi} = 1;
    }
    elsif ($option eq "-m#")
    {
      ($option{multi}, $option{numext}) = (1, 1);
    }
    elsif ($option eq "-null")
    {
      $tmp =~ /\S+/;
      ($option{null}, $tmp) = ($&, $');
      $tmp =~ s/\s*(.*)/\1/;  # ltrim
    }
    elsif ($option eq "-sl")
    {
      $tmp =~ /\S+/;
      ($option{skip}, $tmp) = ($&, $');
      $tmp =~ s/\s*(.*)/\1/;  # ltrim
    }
    elsif ($option eq "-w")
    {
      $tmp =~ /\S+/;
      ($option{width}, $tmp) = ($&, $');
      $tmp =~ s/\s*(.*)/\1/;  # ltrim
    }
  }

  next if $option{error};



  if (@beforebracket)
  {
    print STDERR "Extraneous code (reproduced below) was found below the coding instructions (between curly brackets) in $pgm\n\n";
    foreach (@beforebracket)
    {
      chomp;
      print STDERR $_ . "\n";
    }

    print STDERR "\nOutput script not produced. Sorry.\n\n";
    next;
  }


  if (@code)
  {
    $option{brackets} =~ /(\S)(\S)/;
    ($option{left}, $option{right}) = ($1, $2);

    foreach (@code)
    {
      next unless /\S/;
      my $linked2;

      /([A-Za-z0-9\{\}]+)(\S?)/;
      my ($var, $sep, $values) = ($1, $2, $');
      undef $sep unless $sep =~ /\S/;

      $values =~ s/^\s+|\s+$//g; # lrtrim

      ($var, $linked2) = ($`, $1) if $var =~ /\{([^\}]+)\}/;

      $var           = $option{left} . $var     . $option{right};
      $linked2{$var} = $option{left} . $linked2 . $option{right} if $linked2;

      $parmno{$var} = ++$parmno unless $linked2 || exists $parmno{$var};

      $sep ||= " ";
      $values =~ s/\s+/ /g if $sep eq " ";
      my @tmp = split($sep, $values);


      my $k = 0;
      foreach my $tmp (@tmp)
      {
        my @tmp2;

        if ($tmp =~ /(\d+)\:(\d+)/ && !$` && !$')
        {
          @tmp2 = ($1..$2);
        }
        else
        {
          @tmp2 = ($tmp);
        }

        foreach my $tmp2 (@tmp2)
        {
          $value{$var}{$k++} = $tmp2;
        }
      }
      $nvalues{$var} = $k;
    }
  }
  else
  {
    print STDERR "No loop-code in file $pgm\nSorry.\n\n";
    next;
  }

  # &ListValues(); # causes end of pgm --- for debugging end


  # --- check that each variable linked to another --------------------------------------
  #     has the same number of values as the latter


  foreach my $var (keys %linked2)
  {
    my $l = $linked2{$var};
    if ($nvalues{$var} ne $nvalues{$l})
    {
      print STDERR "Variable $var does not have the same number of values as $l, to which it is linked to (in $pgm)\nSorry.\n";
      $linkProblem = 1;
    }
  }

  next if $linkProblem;


  # ---- Define values foreach 'var'

  $option{nosep} = 1 if $option{multi};

  unless ($option{nosep})
  {
    if ($option{width})
    {
      $option{splitline} = $option{comment} . " ";
      $option{splitline} .= "-" x ($option{width}-length($option{splitline}));
    }
    else
    {
      $option{splitline} = "";
    }
  }


  # ----- Define block size foreach 'var'

  my @parms = sort {$parmno{$b} <=> $parmno{$a}} keys %parmno;

  unless (@parms)
  {
    print STDERR "No parameter to loop over in $pgm\nSorry.\n\n";
    next;
  }


  my $k = 1;
  foreach (@parms)
  {
    $k{$_} = $k;
    $k *= $nvalues{$_};
  }
  $K = $k;


  $option{numext} = 1 if $#parms > 0;


  # --- edit pgm ---------------------------------------------------------------

  chomp @pgm0;


  # Drop leading/trailing blanks,
  # unless user indicated he wanted to preserve them

  unless ($option{keepleadingblanks})
  {
    while (@pgm0)
    {
      my $tmp = shift @pgm0;
      next unless $tmp =~ /\S/;
      unshift(@pgm0, $tmp);
      last;
    }
  }


  unless ($option{keeptrailingblanks})
  {
    while (@pgm0)
    {
      my $tmp = pop @pgm0;
      next unless $tmp =~ /\S/;
      push(@pgm0, $tmp);
      last;
    }
  }


  foreach my $k (1..$K)
  {
    my ($skipFile, @script);
    my $script = $option{script};


    # --- Edit script output filename ------------------------------------------

    foreach my $parm (@parms)
    {
      my $blockno = int(($k-1)/$k{$parm});
      my $i = $blockno%$nvalues{$parm};
      my $v = $value{$parm}{$i};

      if ($v eq $option{skip} && /$parm/)
      {
        $skipFile = 1;
        last;
      }

      $i{$parm} = $i;

      undef $v if $v eq $option{null};
      $script =~ s/$parm/$v/g; # script output filename
    }

    next if $skipFile;


    foreach my $parm (keys %linked2)
    {
      my $v = $value{$parm}{$i{$linked2{$parm}}};

      if ($v eq $option{skip} && /$parm/)
      {
        $skipFile = 1;
        last;
      }

      undef $v if $v eq $option{null};
      $script =~ s/$parm/$v/g;
    }

    next if $skipFile;


    # ---  Edit code -----------------------------------------------------------

    push(@script, $option{splitline}) if defined $option{splitline} && $k > 1;

    my @pgm = @pgm0;
    foreach (@pgm)
    {
      my $skipLine;

      unless (/\S/)
      {
        push(@script, "");
        next;
      }

      foreach my $parm (@parms)
      {
        my $blockno = int(($k-1)/$k{$parm});
        my $i = $blockno%$nvalues{$parm};
        my $v = $value{$parm}{$i};

        if ($v eq $option{skip} && /$parm/)
        {
          $skipLine = 1;
          last;
        }

        $i{$parm} = $i;

        undef $v if $v eq $option{null};
        s/$parm/$v/g;
      }

      next if $skipLine;

      foreach my $parm (keys %linked2)
      {
        my $v = $value{$parm}{$i{$linked2{$parm}}};

        if ($v eq $option{skip} && /$parm/)
        {
          $skipLine = 1;
          last;
        }

        undef $v if $v eq $option{null};
        s/$parm/$v/g;
      }

      next if $skipLine;
      push(@script, $_);
    }


    # --- Add @script to relevant script output file

    my @scriptnos = keys %{$script{$script}};
    my $m = @scriptnos; # Number of scripts

    if ($m > 0)
    {
      if ($option{multi})
      {
        $script{$script}{++$m} = join("\n", @script);
      }
      else
      {
        $script{$script}{1} .= "\n" . join("\n", @script);
      }
    }
    else
    {
      $script{$script}{1} = join("\n", @script);
    }
  }


  # --- Write code to output script files --------------------------------------

  ($dir) = Win32::GetFullPathName($pgm);
  chdir($dir);

  my @scripts = keys %script;

  foreach my $script (@scripts)
  {
    my %s;
    ($s{dir}, $s{name}) = Win32::GetFullPathName($script);

    ($s{name}, $s{ext}) = ($`, $') if $s{name} =~ /\./;
    $s{ext} ||= $option{ext};


    unless (-w $s{dir})
    {
      print STDERR "Cannot write code from script $pgm\nto directory $s{dir}\nSorry.\n\n";
      next;
    }


    my @scriptnos = sort {$a <=> $b} keys %{$script{$script}};
    my $m = @scriptnos;

    foreach my $no (@scriptnos)
    {
      my $ThisScript;

      if ($m == 1)
      {
        $ThisScript = $s{dir} . $s{name} . "." . $s{ext};
      }
      else
      {
        $ThisScript = $s{dir} . $s{name} . "-" . $no . "." . $s{ext};
      }

      open(TMP, ">$ThisScript");
      print TMP $script{$script}{$no};
      close TMP;
    }
  }

  undef %value;
}


die "Done.\n";


# ----- End of code ------------------------------------------------------------


sub OpenSTDERR()
{
  my ($callingpgm, $timestamp, $definegloballogfile) = @_;
  my ($logfile, $logdir);

  # Global variables defined:
  # ------------------------------------------------------- 
  # $LogFile (optionally, that is, if $definegloballogfile)
  # $MyStartTime


  $logfile = "$1.log" if $callingpgm =~ /(.*)\./;
  ($logdir, $logfile) = Win32::GetFullPathName($logfile);
  $logdir = $& . "log\\" if $logdir =~ /c\:\\users\\patrick\.belisle\\Home\\bin\\/i;
  $logfile = $logdir . $logfile;

  open(STDERR, ">$logfile") || die "Cannot write to log file $logfile. Abort.\n";
  print STDERR localtime() . "\n\n" if $timestamp;

  $MyStartTime = time; # defined for future use, as in fct ReportRunTime, for example

  $LogFile = $logfile if $definegloballogfile;
}
