* gph_fig13_7.do

* Choose the directory where you store the files for the book.
* In the book's examples the command is -cd C:\docs\ishr3-

use lbw1.dta, clear
generate lwt130 = lwt-130
quietly: logit low lwt bn.race, noconstant
set scheme lean1

twoway ///
   (function y=(_b[1.race]+x*_b[lwt]), range(50 250) lpattern(1))    ///
   (function y=(_b[2.race]+x*_b[lwt]), range(50 250) lpattern(_))    ///
   (function y=(_b[3.race]+x*_b[lwt]), range(50 250) lpattern(dash)) ///
   ,                                                                 ///
   legend(ring(0) pos(1) order(1 "White"  2 "Black"  3 "Other"))     ///
   xtitle("Weight at last menstrual period (lb)")                    ///
   ytitle("Log odds of low birthweight")                             ///
   xline(130, lpattern(dash))                                        ///
   name(p1, replace)
 
twoway ///
   (function y=invlogit(_b[1.race]+x*_b[lwt]), range(50 250) lpattern(1))    ///
   (function y=invlogit(_b[2.race]+x*_b[lwt]), range(50 250) lpattern(_))    ///
   (function y=invlogit(_b[3.race]+x*_b[lwt]), range(50 250) lpattern(dash)) ///
   ,                                                                         ///
   legend(ring(0) pos(1) order(1 "White"  2 "Black"  3 "Other"))             ///
   xtitle("Weight at last menstrual period (lb)")                            ///
   ytitle("Probability of low birthweight") ylabel(0(0.2)1)                  ///
   xline(130, lpattern(dash)) name(p2,replace) 
 
graph combine p1 p2, xsize(5) ysize(2.2) iscale(1.3)
