* gph_fig15_2.do

* Choose the directory where you store the files for the book.
* In the book's examples the command is -cd C:\docs\ishr3-

use anklebp1.dta, clear
generate diff = adp-atp
generate average = (adp+atp)/2

quietly summarize diff
local DIFMEAN = r(mean)
local PILOW   = r(mean) - 1.96*r(sd)
local PIHIGH  = r(mean) + 1.96*r(sd)

twoway                                      ///
  (scatter diff average)                    ///
  ,                                         ///
  ytitle("Difference")                      ///
  xtitle("Average")                         ///
  yline(`DIFMEAN', lpattern(l))             ///
  yline(`PILOW' `PIHIGH', lpattern(dash))   ///
  ylabel(-75(25)75)                         ///
  ysize(2.2) xsize(3.1) scale(1.4)
