* gph_fig15_4.do

* Choose the directory where you store the files for the book.
* In the book's examples the command is -cd C:\docs\ishr3-

use anklebp2.dta, clear

capture graph drop p1 p2
set scheme lean1
twoway                                           ///
  (scatter adp1 adp2)                            ///
  (function y=x, range(0 200) lpattern(l))       ///
  ,                                              ///
  legend(off)                                    ///
  xtitle("First measurement")                    ///
  ytitle("Second measurement")                   ///
  aspectratio(1) name(p1)

generate diff = adp1-adp2
generate average = (adp1+adp2)/2
quietly summarize diff
local DIFMEAN = r(mean)
local PILOW   = r(mean) - 1.96*r(sd)
local PIHIGH  = r(mean) + 1.96*r(sd)

twoway                                      ///
  (scatter diff average)                    ///
  ,                                         ///
  ytitle("Difference")                      ///
  xtitle("Average")                         ///
  yline(`DIFMEAN', lpattern(l))             ///
  yline(`PILOW' `PIHIGH', lpattern(dash))   ///
  ylabel(-40(20)40)                         ///
  name(p2)
  
graph combine p1 p2, rows(1)      ///
xsize(5.5) ysize(2.2) iscale(1.4)
