* gph_fig17_12.do

set scheme lean1

input year tobacco cancer
1900  .4   .5
1907  .7   .6
1912  .9  1.0
1924 1.9  1.9
1930 2.4  4.0
1936 2.8  7.5
1947 4.2 22.5
end

generate cigarettes = 454*tobacco       // (1 lb = 454 grams)

twoway                                                               ///
  (line cancer year, yaxis(1) lpattern(l))                           ///
  (line cigarettes year, yaxis(2) lpattern(dash))                    ///
  ,                                                                  ///
  xtitle("Year")                                                     ///
  ytitle("Annual lung cancer" "mortality per 100,000", axis(1))      ///
  ytitle("Cigarettes per person per year", axis(2))                  ///
  legend(order(2 "Cigarette consumption" 1 "Lung cancer mortality")) ///
  plotregion(margin(b=0))                                            ///
  xsize(5) ysize(2) aspectratio(0.75) scale(1.4)
