* gph_fig17_29.do

sysuse census.dta
generate urban = 100*popurban/pop
label variable urban "Urbanization (per cent)"
format medage %9.0g
set scheme lean1

twoway                                                                  ///
  (scatter medage urban [fweight=pop], msymbol(Oh) msize(*0.5))         ///
  ,                                                                     ///
  yscale(range(24 35))                                                  ///
  xlabel(30(10)100)                                                     ///
  note("The marker for each state is proportional to population size.") ///
  xsize(2.9) ysize(2.2) scale(1.4)
