* gph_fig17_32.do

input scale n obs sd norm
1 139 60.810 27.346 70.77
2 139 37.650 42.056 62.01
3 136 59.397 28.568 73.66
4 139 57.647 21.686 66.27
5 138 52.754 25.553 64.24
6 137 76.642 26.810 85.85
7 138 51.691 41.869 73.59
8 139 73.065 21.538 79.99
end

generate se=sd/sqrt(n)
generate ci1=obs+1.96*se
generate ci2=obs-1.96*se

label define scale 1 "PF" 2 "RP" 3 "BP" 4 "GH" 5 "VT" 6 "SF" 7 "RE" 8 "MH"
label values scale scale

set scheme lean1

twoway                                                              ///
  (connected obs scale, msymbol(O) lpattern(l))                     ///
  (connected norm scale, msymbol(O) mfcolor(white) lpattern(dash))  ///
  (rcap ci1 ci2 scale)                                              ///
  ,                                                                 ///
  ytitle("Mean score")                                              ///
  xtitle("SF-36 subscale")                                          ///
  xlabel(1(1)8, valuelabel noticks)                                 ///
  xscale(range(0.5 8.5))                                            ///
  legend(order(2 "Expected" 1 "Observed" 3 "95% CI"))               ///
  xsize(3.9) ysize(2.2) scale(1.4)               
