* gph_fig17_32b.do

* Choose the directory where you store the files for the book.
* In the book's examples the command is -cd C:\docs\ishr3-

  use sf36.dta

* ds saves variable names in r(varlist)
  ds pf-mh
  local VARS "`r(varlist)'"

* For each scale (pf to mh) save results from ci on the observed and 
* expected (norm) distribution. Each save gets it own file, e.g.
* "sf36_3.dta" for the observed bp parameters and "sf36_e3.dta" for
* the expected (norm) parameters. 
  forvalues I = 1/8 {
    local V : word `I' of `VARS'
    statsby scale=`I' obs=r(mean) ci1=r(lb) ci2=r(ub),  ///
      saving("sf36_`I'.dta", replace) : ci `V'
    statsby scale=`I' norm=r(mean), ///
      saving("sf36_e`I'.dta", replace) : ci e`V'
  }

* For each scale merge the datasets with observed and expected parameters.
  forvalues I = 1/8 {
    use "sf36_`I'.dta", clear
    merge scale using "sf36_e`I'.dta", sort
    save, replace
  }

* Combine the eight files into one
  use "sf36_1.dta"
  forvalues I = 2/8 {
    append using "sf36_`I'.dta"
  }

* Add value labels.
label define scale 1 "PF" 2 "RP" 3 "BP" 4 "GH" 5 "VT" 6 "SF" 7 "RE" 8 "MH"
label values scale scale

set scheme lean1

twoway                                                              ///
  (connected obs scale, msymbol(O) lpattern(l))                     ///
  (connected norm scale, msymbol(O) mfcolor(white) lpattern(dash))  ///
  (rcap ci1 ci2 scale)                                              ///
  ,                                                                 ///
  ytitle("Mean score")                                              ///
  xtitle("SF-36 subscale")                                          ///
  xlabel(1(1)8, valuelabel noticks)                                 ///
  xscale(range(0.5 8.5))                                            ///
  legend(order(2 "Expected" 1 "Observed" 3 "95% CI"))               ///
  xsize(3.9) ysize(2.2) scale(1.4)               
