*! lprob ver 1.0 27apr2005
*! Calculates probability of outcome after -logistic- or -logit-.
*! Author: Svend Juul
   program lprob
   version 9

* Check that we have saved results from -logistic- or -logit-
  if "`e(cmd)'" != "logistic" & "`e(cmd)'" != "logit" { 
     display as error "lprob only works after -logistic- or -logit-"
     error 301
  }

* If no arguments, include _cons. 
* If _cons is specified, don't include it again;
* otherwise include it.
  if "`0'" == "" {                                      // No arguments
     quietly lincom _cons, or
  }
  else if strpos("`0'","_cons") {                       // _cons specified
     quietly lincom `0', or
  }
  else {                                                // None of the above
     quietly lincom `0' + _cons, or
  }

  local LN_O = ln(r(estimate))                          // ln(odds)
  local SE_LN_O = r(se)/r(estimate)                     // SE(ln(odds))

* Instead of 1.96, use the more precise invnormal(0.975)
  local CIL = exp(`LN_O' - invnormal(0.975)*`SE_LN_O')  // CI for odds
  local CIU = exp(`LN_O' + invnormal(0.975)*`SE_LN_O')  // CI for odds
  local PROB = r(estimate)/(1 + r(estimate))            // Probability
  local CIL = `CIL'/(1 + `CIL')                         // CI for probability
  local CIU = `CIU'/(1 + `CIU')                         // CI for probability



* We want the dependent variable's label in output.
  local VARLAB : variable label `e(depvar)'

* If the dependent variable has no label, don't try to include it;
* if it has, include it in parenthesis.
  display " "

  if "`VARLAB'" == "" {                                 // No variable label
     display as result "Probability of `e(depvar)':"
  }
  else {                                                // Variable label
     display as result "Probability of `e(depvar)' (`VARLAB'):"
  }

  display as result ///
     %08.6f `PROB' " (95% CI: " %08.6f `CIL' " - " %08.6f `CIU' ")"

  end
