*! pinterval ver 3; 12 July 2009
*! Estimates prediction interval
*! Author: Svend Juul
program pinterval           // Version 3 of pinterval.ado
version 10                  // Stata version 10
syntax varlist(min=1 max=1 numeric) [if] [in] [, Level(cilevel)]

* Use default cilevel if not specified
if "`level'"=="" {
   local level = c(level)
} 

* Calculate lower and upper z-values for interval
local ZLO = invnormal((100-`level')/200)
local ZHI = invnormal((100+`level')/200)

* Find mean and SD
summarize `varlist' `if' `in'
local LO = r(mean) + `ZLO'*r(sd)
local HI = r(mean) + `ZHI'*r(sd)

* Display result
display as res _newline `level' "% Prediction interval: " `LO' " - " `HI'
end
