.ss.cons.binom.cdf <-
function(cdf.points, accepted.cdf.diff, 
                                          prior1, prior2,
                                          n.start, n.max, next.n=.ss.nextn4nonrndoutcomes, 
                                          clinical.prior=list(),
                                          target=accepted.cdf.diff, both=F, prior1.mixture.wt=ifelse(both,-1,0), return.worst=F, return.prob=F, increasing.outcome.with.n=F)
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta
    
  alpha1 <- prior1$alpha
  beta1  <- prior1$beta
  alpha2 <- prior2$alpha
  beta2  <- prior2$beta
  alpha3 <- clinical.prior$alpha
  beta3  <- clinical.prior$beta

  # Initial values

  n <- min(n.start, n.max)
  step0 <- max(ceiling(n/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max)


  ss.cons.binom.cdf.out <- function(n, alpha1, beta1, alpha2, beta2, alpha3, beta3, cdf.points, accepted.cdf.diff, return.worst, return.prob, prior1.mixture.wt)
  {
    use.clinical.prior <- length(alpha3) > 0
    
    dBinomialBeta <- function(alpha, beta, n)
    {
      x <- 0:n
      exp(lgamma(alpha+beta)-lgamma(alpha)-lgamma(beta)-lgamma(alpha+beta+n)
         +lgamma(n+1)-lgamma(x+1)-lgamma(n-x+1)+lgamma(alpha+x)+lgamma(beta+n-x))
    }

    # Compute marginal distribution

    if (!return.worst)
    {
      if (use.clinical.prior)
      {
        mx <- dBinomialBeta(alpha3, beta3, n)
      }
      else
      {
        m1 <- dBinomialBeta(alpha1, beta1, n)
        m2 <- dBinomialBeta(alpha2, beta2, n)
        if (prior1.mixture.wt < 0)
        {
          mx <- c(m1, m2)
        }
        else
        {
          mx <- prior1.mixture.wt*m1 + (1-prior1.mixture.wt)*m2
        }
      }
      mx <- matrix(mx, nrow=n+1)
    }

    # Compute absolute differences g_n(x) in cumulative posterior probabilites

    x <- 0:n

    lq <- length(cdf.points)
    rep.cdf.points <- rep(cdf.points, rep(n+1,lq))

    p1 <- pbeta(rep.cdf.points, alpha1+x, beta1+n-x)
    p2 <- pbeta(rep.cdf.points, alpha2+x, beta2+n-x)
    pdiff <- matrix(abs(p2-p1), ncol=lq)

    if (return.worst)
    {
      out <- max(pdiff)
    }
    else 
    {
      gn.x <- apply(pdiff,1,max)
      
      if (return.prob)
      {
        out <- gn.x <= accepted.cdf.diff 
      }
      else
      {
        out <- gn.x 
      }
      
      out <- t(mx)%*%matrix(out,ncol=1)
      out <- ifelse(return.prob, min(out), max(out))
    }
    
    out
  } # end of ss.cons.binom.cdf.out

  # ---

  while (out$continue)
  {
    z <- ss.cons.binom.cdf.out(n, alpha1, beta1, alpha2, beta2, alpha3, beta3, cdf.points, accepted.cdf.diff, return.worst, return.prob, prior1.mixture.wt)

    outcome <- c(z, outcome)
    n.visited <- c(n, n.visited)

    out$outcome <- outcome
    out$n.visited <- n.visited

    nextn <- next.n(out)
    out$continue <- nextn$continue
    n <- nextn$n
  }

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome))
}
.ss.cons.binom.check.list <-
function(test.prior=list(), prior.name)
{
  if (missing(test.prior))
  {
    stop(paste(c(prior.name, " list undefined."), collapse=''), call.=F) 
  }
  else
  {
    tmp <- try(paste(test.prior), silent=T)
    if (class(tmp) != "try-error")
    {
      dim.names <- names(test.prior)
      present.dim <- match(c("alpha", "beta"), dim.names)
      if (any(is.na(present.dim))) stop(paste(c("Both alpha and beta must be dimensions of ", prior.name, " list."), collapse=''), call.=F)
    }
    else
    {
      stop(paste(c(prior.name, " list undefined."), collapse=''), call.=F)
    }
  }
}
.ss.cons.binom.hpdlimits <-
function(accepted.pdiff, prior1, prior2, 
                                               level, fast.approx,
                                               n.start, n.max, next.n=.ss.nextn4nonrndoutcomes,
                                               clinical.prior=list(), 
                                               target, both=F, prior1.mixture.wt=ifelse(both,-1,0), return.worst=F, return.prob=F, increasing.outcome.with.n=F, epsilon=1e-8)
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta
      
  alphas <- c(prior1$alpha, prior2$alpha, clinical.prior$alpha)
  betas  <- c(prior1$beta,  prior2$beta,  clinical.prior$beta)
  use.clinical.prior <- .ss.cons.defined.list(clinical.prior)
  

  # Initial values

  n <- min(n.start, n.max)
  step0 <- max(ceiling(n/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max)


  while (out$continue)
  {
    z <- .C("BinomConsensus", as.double(alphas), as.double(betas), as.integer(n),
             as.double(level), as.integer(fast.approx),
             out=double(1), as.integer(return.worst), as.integer(return.prob), as.double(prior1.mixture.wt), as.integer(use.clinical.prior),
             as.double(accepted.pdiff), as.double(epsilon))

    outcome <- c(z$out, outcome)
    n.visited <- c(n, n.visited)

    out$outcome <- outcome
    out$n.visited <- n.visited

    nextn <- next.n(out)
    out$continue <- nextn$continue
    n <- nextn$n
  }

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome))
}
.ss.cons.binom.q <-
function(quantiles, accepted.pdiff,
                                               prior1, prior2,
                                               n.start, n.max, next.n=.ss.nextn4nonrndoutcomes, 
                                               clinical.prior=list(),
                                               target=accepted.pdiff, both=F, prior1.mixture.wt=ifelse(both,-1,0), return.worst=F, return.prob=F, increasing.outcome.with.n=F)
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta

  alpha1 <- prior1$alpha
  beta1  <- prior1$beta
  alpha2 <- prior2$alpha
  beta2  <- prior2$beta
  alpha3 <- clinical.prior$alpha
  beta3  <- clinical.prior$beta

  # Initial values

  n <- min(n.start, n.max)
  step0 <- max(ceiling(n/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max)


  ss.cons.binom.q.out <- function(n, alpha1, beta1, alpha2, beta2, alpha3, beta3, quantiles, accepted.pdiff, return.worst, return.prob, prior1.mixture.wt)
  {
    use.clinical.prior <- length(alpha3) > 0
    
    dBinomialBeta <- function(alpha, beta, n)
    {
      x <- 0:n
      exp(lgamma(alpha+beta)-lgamma(alpha)-lgamma(beta)-lgamma(alpha+beta+n)
         +lgamma(n+1)-lgamma(x+1)-lgamma(n-x+1)+lgamma(alpha+x)+lgamma(beta+n-x))
    }

    # Compute marginal distribution

    if (!return.worst)
    {
      if (use.clinical.prior)
      {
        mx <- dBinomialBeta(alpha3, beta3, n)
      }
      else
      {
        m1 <- dBinomialBeta(alpha1, beta1, n)
        m2 <- dBinomialBeta(alpha2, beta2, n)
        if (prior1.mixture.wt < 0)
        {
          mx <- c(m1, m2)
        }
        else
        {
          mx <- prior1.mixture.wt*m1 + (1-prior1.mixture.wt)*m2
        }
      }
      mx <- matrix(mx, nrow=n+1)
    }

    # Compute absolute differences g_n(x) in cumulative posterior probabilites

    x <- 0:n

    q.len <- length(quantiles)
    rep.quantiles <- rep(quantiles, rep(n+1,q.len))

    q1 <- qbeta(rep.quantiles, alpha1+x, beta1+n-x)
    q2 <- qbeta(rep.quantiles, alpha2+x, beta2+n-x)
    qdiff <- matrix(abs(q2-q1), ncol=q.len)

    if (return.worst)
    {
      out <- max(qdiff)
    }
    else
    {
      gn.x <- apply(qdiff,1,max)

      if (return.prob)
      {
        out <- gn.x <= accepted.pdiff
      }
      else
      {
        out <- gn.x
      }

      out <- t(mx)%*%matrix(out,ncol=1)
      out <- ifelse(return.prob, min(out), max(out))
    }

    out
  } # end of ss.cons.binom.q.out

  # ---

  while (out$continue)
  {
    z <- ss.cons.binom.q.out(n, alpha1, beta1, alpha2, beta2, alpha3, beta3, quantiles, accepted.pdiff, return.worst, return.prob, prior1.mixture.wt)

    outcome <- c(z, outcome)
    n.visited <- c(n, n.visited)

    out$outcome <- outcome
    out$n.visited <- n.visited

    nextn <- next.n(out)
    out$continue <- nextn$continue
    n <- nextn$n
  }

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome))
}
.ss.cons.defined.list <-
function(mylist){ifelse(length(mylist) == 0, F, any(unlist(lapply(mylist, length)) > 0))}
.ss.nextn4nonrndoutcomes <-
function(mylist)
{
  # Function used to perform the bisectional search

  ##################################################################
  # mylist: consists in a list of the following arguments:
  # -------
  #
  # n.visited
  # outcome
  # target
  # step0
  # increasing.outcome.with.n
  # n.max
  #
  ##################################################################

  continue <- T

  sufficient.n <- (mylist$increasing.outcome.with.n & mylist$outcome >= mylist$target) | (!mylist$increasing.outcome.with.n & mylist$outcome <= mylist$target)
  n.visited <- mylist$n.visited

  if (all(sufficient.n))
  {
    n.visited <- sort(n.visited)

    if (n.visited[1] == 0)
    {
      n <- 0
      continue <- F
    }
    else
    {
      if (length(n.visited) == 1)
      {
        n <- max(n.visited - mylist$step0, 0)
      }
      else
      {
        n <- max(n.visited[1] - 2*diff(n.visited[1:2]), 0)
      }
    }
  }
  else if (all(!sufficient.n))
  {
    n.visited <- rev(sort(n.visited))

    if (n.visited[1] == mylist$n.max)
    {
      n <- Inf
      continue <- F
    }
    else
    {
      if (length(n.visited) == 1)
      {
        n <- n.visited + mylist$step0
      }
      else
      {
        n <- n.visited[1] + 2 * (n.visited[1]-n.visited[2])
      }

      n.visited <- min(n.visited, mylist$n.max)
    }
  }
  else
  {
    smallest.sufficient.n  <- min(n.visited[sufficient.n])
    largest.insufficient.n <- max(n.visited[!sufficient.n])

    if ((smallest.sufficient.n-largest.insufficient.n) == 1)
    {
      n <- smallest.sufficient.n
      continue <- F
    }
    else
    {
      n <- floor((smallest.sufficient.n + largest.insufficient.n)/2)
    }
  }
  
  if (n > mylist$n.max)
  {
    n <- Inf
    continue <- F
  }

  # If continue=F, then n indicates the optimal sample size found

  list(n=n, continue=continue)
}
