ss.cons.binom.prob.cdf.bothmarg <-
function(cdf.points, accepted.cdf.diff, prior1, prior2, prob=0.5,
                                                       n.start=1000, n.max=1e7)
{
  # prior1 and prior2 must be lists with dimensions alpha & beta
  tmp <- .ss.cons.binom.check.list(prior1, "prior1")
  tmp <- .ss.cons.binom.check.list(prior2, "prior2")


  tmp <- .ss.cons.binom.cdf(cdf.points, accepted.cdf.diff, prior1, prior2,
                                       n.start, n.max, target=prob, both=T, return.prob=T, increasing.outcome.with.n=T)

  tmp <- c(tmp, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, prior1=prior1, prior2=prior2, prob=prob, n.start=n.start, n.max=n.max))
  tmp
}
