ss.cons.binom.worst.hpdlimits <-
function(accepted.pdiff, prior1, prior2,
                                                    level=0.95, n.max=1e7,
                                                    fast.approx=T)
{
  # prior1 and prior2 must be lists with dimensions alpha & beta
  tmp <- .ss.cons.binom.check.list(prior1, "prior1")
  tmp <- .ss.cons.binom.check.list(prior2, "prior2")
  
  
  nStart.consensus.binom <- function(alphas, betas, accepted.pdiff, level)
  {
    # To find starting value for sample size, based on assumption
    # that sample size required will be large, assuming that
    # worst outcome (in terms of posterior quantiles differences)
    # will be with either no success or no failure in the observed data,
    # and using normal approximation to posterior distributions (betas with
    # large value for sample size equivalence [alpha+beta])

    z <- qnorm((1+level)/2)
    tau <- alphas + betas

    solns <- numeric(0)
    for (g1 in c(-1,1))
    {
      eta <- alphas + g1 * z * sqrt(alphas)
      rho <- alphas + g1 * z * sqrt(betas)

      for (g2 in c(-1,1))
      {
        A <- g2 * accepted.pdiff
        B <- A * sum(tau) + diff(eta)
        C <- eta[2]*tau[1] - eta[1]*tau[2] + A * prod(tau)
        
        delta <- B*B - 4*A*C
        if (delta >= 0)
        {
          solns0 <- (-B + c(-1,1)*sqrt(B*B-4*A*C))/(2*A)
          solns <- c(solns, solns0)
        }

        B <- A * sum(tau) + diff(rho) - diff(tau)
        C <- rho[2]*tau[1] - rho[1]*tau[2] + A * prod(tau)
        
        delta <- B*B - 4*A*C
        if (delta >= 0)
        {
          solns0 <- (-B + c(-1,1)*sqrt(B*B-4*A*C))/(2*A)
          solns <- c(solns, solns0)
        }
      }
    }

    ceiling(max(solns, na.rm=T))
  } # end of nStart.consensus.binom

  alphas  <- as.double(c(prior1$alpha, prior2$alpha))
  betas   <- as.double(c(prior1$beta,  prior2$beta))
  n.start <- nStart.consensus.binom(alphas, betas, accepted.pdiff, level)

  tmp <- .ss.cons.binom.hpdlimits(accepted.pdiff, prior1, prior2, level, fast.approx,
                                            n.start, n.max, target=accepted.pdiff, return.worst=T)

  tmp <- c(tmp, list(accepted.pdiff=accepted.pdiff, prior1=prior1, prior2=prior2, level=level, n.max=n.max, fast.approx=fast.approx))
  tmp
}
