\name{ss.cons.binom.prob.hpdlimits}
\alias{ss.cons.binom.prob.hpdlimits}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.cons.binom.prob.hpdlimits(accepted.pdiff, prior1, prior2, prior1.mixture.wt = 0.5, prob = 0.5, level = 0.95, n.start = 1000, n.max = 1e+07)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{accepted.pdiff}{
The accepted difference between the two <A>; any difference below that value is considered as meeting the consensus criterion.
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{prior1.mixture.wt}{
Clinical prior distibution --- used to generate the data --- is a mixture of the two prior distributions, with weight \emph{prior1.mixture.wt} assigned to \emph{prior1} and \emph{1-prior1.mixture.wt} to \emph{prior2}.
}
  \item{prob}{
The probability (in terms of the preposterior distribution of the data) with which the consensus criterion must be met.
}
  \item{level}{
Coverage probability of the two HPD intervals.
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
}
\details{
  Prior distribution (\code{prior1} and \code{prior2}) must be specified through a list with parameters \code{alpha} and \code{beta},
  respectively, the first and second parameters of the Beta distribution for the binomial proportion.
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{  Lawrence Joseph \email{lawrence.joseph\@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.binom.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.binom.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.binom.avg.hpdlimits}},
   \code{\link{ss.cons.binom.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.binom.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.binom.worst.hpdlimits}},
   \code{\link{ss.cons.binom.prob.cdf}}, \code{\link{ss.cons.binom.prob.cdf.bothmarg}}, \code{\link{ss.cons.binom.prob.cdf.mymarg}},
   \code{\link{ss.cons.binom.avg.cdf}}, \code{\link{ss.cons.binom.avg.cdf.bothmarg}}, \code{\link{ss.cons.binom.avg.cdf.mymarg}}, \code{\link{ss.cons.binom.worst.cdf}},
   \code{\link{ss.cons.binom.prob.q}}, \code{\link{ss.cons.binom.prob.q.bothmarg}}, \code{\link{ss.cons.binom.prob.q.mymarg}},
   \code{\link{ss.cons.binom.avg.q}}, \code{\link{ss.cons.binom.avg.q.bothmarg}}, \code{\link{ss.cons.binom.avg.q.mymarg}},
   \code{\link{ss.cons.binom.worst.q}}
}
\examples{
accepted.pdiff <- 0.005
prior1 <- list(alpha=116.064,   beta=12.04506)    # 95% CI:  .85 - .95
prior2    <- list(alpha=194.0375,  beta=47.79375)    # 95% CI:  .75 - .85
z <- ss.cons.binom.prob.hpdlimits(accepted.pdiff, prior1, prior2, prob=0.9)
z$n
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
