\name{ss.plot}
\alias{ss.plot}
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.plot(ss.out, zero = 0.1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ss.out}{
The output of a CBSS sample size function.
}
  \item{zero}{
An alternative value for \emph{n} in the plotting of \emph{log(n)} when \emph{n = 0}.
}
  \item{show.fit}{
Whether or not a tentative fit curve will be displayed.
}
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{  Lawrence Joseph \email{lawrence.joseph\@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.cons.binom.avg.hpdlimits}}, \code{\link{ss.cons.binom.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.binom.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.binom.prob.hpdlimits}}, \code{\link{ss.cons.binom.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.binom.prob.hpdlimits.mymarg}},
   \code{\link{ss.cons.binom.worst.hpdlimits}}, \code{\link{ss.cons.binom.avg.cdf}}, \code{\link{ss.cons.binom.avg.cdf.bothmarg}},
   \code{\link{ss.cons.binom.avg.cdf.mymarg}}, \code{\link{ss.cons.binom.prob.cdf}}, \code{\link{ss.cons.binom.prob.cdf.bothmarg}},
   \code{\link{ss.cons.binom.prob.cdf.mymarg}}, \code{\link{ss.cons.binom.worst.cdf}}, \code{\link{ss.cons.binom.avg.q}}, \code{\link{ss.cons.binom.avg.q.bothmarg}},
   \code{\link{ss.cons.binom.avg.q.mymarg}}, \code{\link{ss.cons.binom.prob.q}}, \code{\link{ss.cons.binom.prob.q.bothmarg}},
   \code{\link{ss.cons.binom.prob.q.mymarg}}, \code{\link{ss.cons.binom.worst.q}}
}
\examples{
accepted.pdiff <- 0.005
prior1 <- list(alpha=116.064,   beta=12.04506) # 95% CI:  .85 - .95
prior2    <- list(alpha=194.0375,  beta=47.79375) # 95% CI:  .75 - .85
z <- ss.cons.binom.avg.hpdlimits(accepted.pdiff, prior1, prior2)
ss.plot(z)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
