/* Do not edit this file */



#include <float.h>
#include <malloc.h>
#include <R.h>
#include <Rmath.h>
#include <stdio.h>

/* The algorithm below was described in

    Bayesian Sample Size Determination for Binomial Proportions
    Cyr E. MLan, Lawrence Joseph and David B. Wolfson
    Bayesian Analysis (2008) 3, Number 2, pp. 269296
    (particularly on pages 273 & 285)
*/


double InvLogit(double u)
{
  double res;

  if (u > 30.0)
  {
    res = 1.0;
  }
  else if (u < -30.0)
  {
    res = 0.0;
  }
  else
  {
    res = 1/(1 + exp(-u));
  }

  return(res);
}



void BetaHPD(long *HPDLengthIsFixed, double *target, long *nElem, double *alpha, double *beta, double *epsilon,
             long *returnHPDLimits, double *res)
{
  int cont, dir, i, resIndex = 0, UShape = 0;
  double a, change, *e, g, *gelem, gprime, *gprimeElem, log_sd, mode,
    *p,  *pChange, pChangeMax, pLeft, pMode, *pprime, *previousp, pRight, sd, u, *uelem, uprime, w, z;


  /* Objects declaration */
  e          = (double *) malloc(2 * sizeof(double));
  gelem      = (double *) malloc(2 * sizeof(double));
  gprimeElem = (double *) malloc(2 * sizeof(double));
  p          = (double *) malloc(2 * sizeof(double));
  pChange    = (double *) malloc(2 * sizeof(double));
  pprime     = (double *) malloc(2 * sizeof(double));
  previousp  = (double *) malloc(2 * sizeof(double));
  uelem      = (double *) malloc(2 * sizeof(double));


  for (i=0;i<*nElem;i++)
  {
    if ((*(alpha+i) <= 1.0 && *(beta+i) >= 1.0) || (*(alpha+i) >= 1.0 && *(beta+i) <= 1.0))
    {
      if (*(alpha+i) == 1.0 && *(beta+i) == 1.0)
      {
        if (*returnHPDLimits)
        {
          *(res+resIndex)   = (1-*target)/2;
          *(res+resIndex+1) = (1+*target)/2;
        }
        else
        {
          *(res+resIndex) = *target;
        }
      }
      else if (*(alpha+i) < *(beta+i))
      {
        if (*returnHPDLimits)
        {
          *(res+resIndex) = 0.0;
          *(res+resIndex+1) = *HPDLengthIsFixed ? *target : qbeta(*target, *(alpha+i), *(beta+i), 1, 0);
        }
        else if (*HPDLengthIsFixed)
        {
          *(res+resIndex) = pbeta(*target, *(alpha+i), *(beta+i), 1, 0);
        }
        else
        {
          *(res+resIndex) = qbeta(*target, *(alpha+i), *(beta+i), 1, 0);
        }
      }
      else
      {
        /* alpha[i] > beta[i] */

        if (*returnHPDLimits)
        {
          *(res+resIndex) = *HPDLengthIsFixed ? 1-*target : qbeta(1-*target, *(alpha+i), *(beta+i), 1, 0);
          *(res+resIndex+1) = 1.0;
        }
        else if (*HPDLengthIsFixed)
        {
          *(res+resIndex) = pbeta(1-*target, *(alpha+i), *(beta+i), 0, 0);
        }
        else
        {
          *(res+resIndex) = 1 - qbeta(*target, *(alpha+i), *(beta+i), 0, 0);
        }
      }
    }
    else
    {
      if (*(alpha+i) < 1.0) UShape = 1, *target = 1 - *target;

      /* Parms declaration */

      a = (*(alpha+i)-1)/(*(alpha+i)+*(beta+i)-2);
      mode = (*(alpha+i) - 1)/(*(alpha+i) + *(beta+i) - 2);
      cont = 1, dir = -1;


      /* Starting values */

      if (*HPDLengthIsFixed)
      {
        *p = mode;
        change = *p;

        while (cont)
        {
          change /= 2;
           *p += change * dir;
           *(p+1) = *p + *target;

           if (*(p+1) < mode)
           {
              dir = 1;
           }
           else if (*(p+1) > 1.0)
           {
             dir = -1;
           }
           else
           {
             cont = 0;
           }
        }
      }
      else
      {
	    log_sd = (log(*(alpha+i)) + log(*(beta+i)) - log(*(alpha+i) + *(beta+i) + 1)) / 2 - log(*(alpha+i) + *(beta+i));
		

        if (log_sd > -7)
		{
          pMode = pbeta(mode, *(alpha+i), *(beta+i), 1, 0);
          pLeft = pMode;
          change = pLeft;

          while (cont)
          {
            change /= 2;
            pLeft += dir * change;
            pRight = pLeft + *target;

            if (pRight < pMode)
            {
              dir = 1;
            }
            else if (pRight > 1.0)
            {
              dir = -1;
            }
            else
            {
              cont = 0;
            }
          }

          *p     = qbeta(pLeft,  *(alpha+i), *(beta+i), 1, 0);
          *(p+1) = qbeta(pRight, *(alpha+i), *(beta+i), 1, 0);
		}
		else
		{
		  z = qnorm((1+*target)/2, 0, 1, 1, 0);
		  sd = exp(log_sd);

		  *p = mode - z * sd;
		  *(p+1) = mode + z * sd;

		  if (*p < 0) *p = mode / 2;
		  if (*(p+1) > 1) *(p+1) = (1 + mode) / 2;
		}
      }


      w = InvLogit(*(p+1)) - InvLogit(*p);


      /* Newton-Raphson algorithm */

      cont = 1;
      *e = exp((a-1)*w), *(e+1) = exp(-a*w);
      *uelem = 1.0 - *e, *(uelem+1) = 1.0 - *(e+1);


      if (*HPDLengthIsFixed)
      {
        /* Fixed Length */

        while (cont > 0)
        {
          *previousp = *p, *(previousp+1) = *(p+1);

          uprime = (a-1) + *(e+1) * a / *(uelem+1) +  *e * (a-1) / *uelem;
          *pprime = uprime * *p * (1-*p), *(pprime+1) = (uprime+1) * *(p+1) * (1-*(p+1));
          g = *(p+1) - *p - *target;
          gprime = *(pprime+1) - *pprime;

          w -= g/gprime;
          *e = exp((a-1)*w), *(e+1) = exp(-a*w);
          *uelem = 1.0 - *e, *(uelem+1) = 1.0 - *(e+1);
          u = (a-1)*w + log(*(uelem+1)) - log(*uelem);
          *p = InvLogit(u), *(p+1) = InvLogit(u+w);

          *pChange = fabs(*p - *previousp), *(pChange+1) = fabs(*(p+1) - *(previousp+1));
          pChangeMax = *(pChange+1) > *pChange ? *(pChange+1) : *pChange;
          if (pChangeMax < *epsilon) cont = 0;
        }
      }
      else
      {
        /* Fixed Coverage */

        while (cont > 0)
        {
          *previousp = *p, *(previousp+1) = *(p+1);

          uprime = (a-1) + *(e+1) * a / *(uelem+1) + *e * (a-1) / *uelem;
          *pprime = uprime * *p * (1-*p), *(pprime+1) = (uprime+1) * *(p+1) * (1-*(p+1));
          *gelem = pbeta(*p, *(alpha+i), *(beta+i), 1, 0), *(gelem+1) = pbeta(*(p+1), *(alpha+i), *(beta+i), 1, 0);
          g = *(gelem+1) - *gelem - *target;
          *gprimeElem = dbeta(*p, *(alpha+i), *(beta+i), 0), *(gprimeElem+1) = dbeta(*(p+1), *(alpha+i), *(beta+i), 0);
          gprime = *(gprimeElem+1)*(*(pprime+1)) - *gprimeElem*(*pprime);

          w -= g/gprime;
          *e = exp((a-1)*w), *(e+1) = exp(-a*w);
          *uelem = 1.0 - *e, *(uelem+1) = 1.0 - *(e+1);
          u = (a-1)*w + log(*(uelem+1)) - log(*uelem);
          *p = InvLogit(u), *(p+1) = InvLogit(u+w);

          *pChange = fabs(*p - *previousp), *(pChange+1) = fabs(*(p+1) - *(previousp+1));
          pChangeMax = *(pChange+1) > *pChange ? *(pChange+1) : *pChange;
          if (pChangeMax < *epsilon) cont = 0;
        }
      }


      if (*returnHPDLimits)
      {
        *(res+resIndex) = *p, *(res+resIndex+1) = *(p+1);
      }
      else if (*HPDLengthIsFixed)
      {
        /* return HPD interval coverage */

        if (UShape)
        {
          *(res+resIndex) = pbeta(*(p+1), *(alpha+i), *(beta+i), 0, 0) + pbeta(*p, *(alpha+i), *(beta+i), 1, 0);
        }
        else
        {
          *(res+resIndex) = pbeta(*(p+1), *(alpha+i), *(beta+i), 1, 0) - pbeta(*p, *(alpha+i), *(beta+i), 1, 0);
        }
      }
      else
      {
        /* return HPD interval length */

        if (UShape)
        {
          *(res+resIndex) = *p + 1 - *(p+1);
        }
        else
        {
          *(res+resIndex) = *(p+1) - *p;
        }
      }


      if (UShape) *target = 1 - *target, UShape = 0;
    }

    resIndex += *returnHPDLimits ? 2 : 1;
  }


  free(e), free(gelem), free(gprimeElem),
  free(p), free(pChange), free(pprime), free(previousp), free(uelem);
}



double AbsLogDiff(double x, double y)
{
  double res;

  res = x > y ? x : y;
  res += log(fabs(exp(x-res) - exp(y-res)));

  return(res);
}


void BetaMoments(double *mean, double *var, double a, double b)
{
  *mean = a/(a+b);
  *var = a*b/((a+b)*(a+b)*(a+b+1.0));
}


void BetaParmsFromMoments(double *alpha, double *beta, double mean, double var)
{
  *alpha = mean*mean*(1.0-mean)/var-mean;
  *beta = *alpha * (1.0/mean-1.0);
}


void BetaDiff4NonRnd(long *todo, long *lz, double *z, long *n, long *both, double *AcceptedDiff, double *alpha, double *beta, double *pr1, double *pr2, long *returnWorst, long *returnProb, double *out)
{
  double *diffAlpha, *diffBeta, diffMean, diffVar, *mean, *myout, res = 0.0, *resElem, tmpres, *var, x1x2prob;
  long HPDLengthIsFixed = 0, mAlpha = 2, prCol, prNCols = 1 + *both, returnHPDLimits = 1, s, x1, x2;
  int k;
  double NewtonRaphsonEpsilon = 0.00000001;

  /* Input parms
     -----------

    *todo = 0  compute HPD interval limits
          = 1  compute pbeta
          = 2  compute qbeta

    *alpha: vector of length 4 < specialist1 (gr1 gr2) specialist2 (gr1 gr2) >
    *beta:  as above

    *pr1 : vector of probabilities for x1 (*x) in (0,1,...*n)
         - of length *n + 1       if both = F
         - of length (*n + 1) x 2 if both = T
    *pr2 : vector of probabilities for x2 (*(x+1) in (0,1,...*(n+1))
         - of length  *(n+1) + 1      if both = F
         - of length (*(n+1) + 1) x 2 if both = T

    *returnWorst : 0/1, of length 1
    *returnProb  : as above

    *n : vector of length 2

    *z = level (todo=0)
         cumulative.comparison.points (todo=1)
         quantiles (todo=2)

    *lz = length of *z

    C-code parms
    ------------
    mean: vector of length 4, in order gr1(specialist1 specialist2) gr2(specialist1 specialist2)
    var:  same as above
  */


  diffAlpha = (double *) malloc(2 * sizeof(double));
  diffBeta  = (double *) malloc(2 * sizeof(double));
  mean      = (double *) malloc(4 * sizeof(double));
  myout     = (double *) malloc(2 * sizeof(double));
  resElem   = (double *) malloc(4 * sizeof(double));
  var       = (double *) malloc(4 * sizeof(double));

  *myout = *(myout+1) = 0.0;
  for (s=0;s<4;s++) *(mean+s) = *(var+s) = *(resElem+s) = 0.0;
  for (s=0;s<2;s++) *(diffAlpha+s) = *(diffBeta+s)= 0.0;

  if (*returnWorst > 0) *out = -10.0;

  /* Loop over possible outcomes (in both groups) */

  for (x1=0;x1<=*n; x1++)
  {
    for (s=0;s<2;s++) BetaMoments(mean+s, var+s, *(alpha+2*s)+x1, *(beta+2*s)+*n-x1);

    for (x2=0;x2<=*(n+1);x2++)
    {
      for (s=0;s<2;s++)
      {
        BetaMoments(mean+2+s, var+2+s, *(alpha+2*s+1)+x2, *(beta+2*s+1)+*(n+1)-x2);

        /* Compute (rescaled to 0/1 range) moments for the approx Beta distrn of the difference between the two proportions */
        diffMean = (*(mean+2+s) - *(mean+s) + 1)/2;
        diffVar = (*(var+s) + *(var+2+s))/4;

        BetaParmsFromMoments(diffAlpha+s, diffBeta+s, diffMean, diffVar);
      }


      if (*todo == 0)
      {
        /* Compute HPD intervals */
        BetaHPD(&HPDLengthIsFixed, z, &mAlpha, diffAlpha, diffBeta, &NewtonRaphsonEpsilon, &returnHPDLimits, resElem);
        for (s=0;s<2;s++) *(resElem+s) = fabs(*(resElem+2+s)-*(resElem+s));
        res = *(resElem+1) > *resElem ? *(resElem+1) : *resElem;
      }
      else if (*todo == 1)
      {
        /* Compute pbeta, loop over z (cumulative.comparison.points) */
        for (k=0;k<*lz;k++)
        {
          for (s=0;s<2;s++) *(resElem+s) = pbeta(*(z+k), *(diffAlpha+s), *(diffBeta+s), 1, 0);
          tmpres = fabs(*(resElem+1) - *resElem);
          if (k == 0 || tmpres > res) res = tmpres;
        }
      }
      else
      {
        /* Compute qbeta, loop over z (quantiles) */
        for (k=0;k<*lz;k++)
        {
          for (s=0;s<2;s++) *(resElem+s) = qbeta(*(z+k), *(diffAlpha+s), *(diffBeta+s), 1, 0);
          tmpres = fabs(*(resElem+1) - *resElem);
          if (k == 0 || tmpres > res) res = tmpres;
        }
      }


      if (*returnWorst > 0)
      {
        if (res > *out) *out = res;
      }
      else
      {
        /* *returnWorst == 0 */

        if (*returnProb > 0)
        {
          if (res <= *AcceptedDiff)
          {
            for (prCol=0;prCol<prNCols;prCol++)
            {
              x1x2prob = *(pr1+x1+(*n+1)*prCol) * (*(pr2+x2+(*(n+1)+1)*prCol));
              *(myout+prCol) += x1x2prob;
            }
          }
        }
        else
        {
          /* compute avg */
          for (prCol=0;prCol<prNCols;prCol++)
          {
            x1x2prob = *(pr1+x1+(*n+1)*prCol) * (*(pr2+x2+(*(n+1)+1)*prCol));
            *(myout+prCol) += x1x2prob * res;
          }
        }
      }
    }
  }


  /* Return result */

  if (*both)
  {
    if (*returnProb)
    {
      *out = *myout < *(myout+1) ? *myout : *(myout+1);
    }
    else
    {
      *out = *myout > *(myout+1) ? *myout : *(myout+1);
    }
  }
  else
  {
    *out = *myout;
  }


  free(diffAlpha), free(diffBeta), free(mean), free(myout), free(resElem), free(var);
}


void BinomConsensus(double *alpha, double *beta, long *n, double *level, long *fast,
                    double *out, long *returnWorst, long *returnProb, double *f0, long *use3, double *AcceptedProbDiff, double *NewtonRaphsonEpsilon)
{
  double *fx, *log_fx, *fxtot, *HPDLimits, *lgamma0, *lim0, *lim1, *myalpha, *mybeta,*tmp_out,
         *Alpha, *Beta;
  long i, d, mHPDLimits = 2*(*n + 1), returnHPDLimits = 1, x, xstep = 1, D = 2;
  double diff0, diff1, diff;
  double ONE = 0.99999;
  long HPDLengthIsFixed = 0;


  /* alpha, beta: 2 vectors, each of length 2, with alpha & beta parms
     of the two priors that have to come to consensus

     *returnWorst = 1 (T) -> compute worst absolute difference
     *returnProb  = 1 (T) -> compute prob that absolute difference is <= *AcceptedProbDiff
     otherwise:           -> compute avg absolute difference

     *f0 : fraction of final marginal coming from first prior described
         == -1.0 -> criterion has to be satisfied for marginal as derived from
                    both skeptical and enthusiastic priors
  */


  fx        = (double *) malloc( 2             * sizeof(double));
  fxtot     = (double *) malloc( 2             * sizeof(double));
  HPDLimits = (double *) malloc( 2* mHPDLimits * sizeof(double));
  lgamma0   = (double *) malloc( 2             * sizeof(double));
  lim0      = (double *) malloc( 2             * sizeof(double));
  lim1      = (double *) malloc( 2             * sizeof(double));
  log_fx    = (double *) malloc( 2             * sizeof(double));
  myalpha   = (double *) malloc( mHPDLimits    * sizeof(double));
  mybeta    = (double *) malloc( mHPDLimits    * sizeof(double));
  tmp_out   = (double *) malloc( 2             * sizeof(double));

  Alpha     = (double *) malloc( 2             * sizeof(double));
  Beta      = (double *) malloc( 2             * sizeof(double));


  /* Initialize table vars */

  for (i=0;i<2;i++)
  {
    *(lim0+i) = *(lim1+i) = -2.0;
    *(fx+i) = *(log_fx+i) = *(fxtot+i) = *(tmp_out+i) = *(lgamma0+i) = 0.0;
    *(Alpha+i) = *(Beta+i) = 0.0;
  }

  for (i=0;i<2*mHPDLimits;i++) *(HPDLimits+i) = 0.0;

  *out = 0.0;
  if (*returnWorst == 1 && *fast) xstep = *n;


  /* Define Alpha and Beta, the prior parms to use to
     to derive the marginal used for probs/avg_precs */

  if (*use3)
  {
    D = 1;
    *Alpha = *(alpha+2), *Beta = *(beta+2);
  }
  else
  {
    for (d=0;d<2;d++) *(Alpha+d) = *(alpha+d), *(Beta+d) = *(beta+d);
  }


  /* ---------------------------------------------------------------------
     If necessary (if *returnWorst = 0), compute marginal distribution for x,
     from the two different priors provided (skeptical and enthusiastic)

     Note: marginal distrn for x is BinomialBeta
  */


  if (*returnWorst == 0)
  {
    for (d=0;d<D;d++)
    {
      *(lgamma0+d) = lgamma(*(Alpha+d)+*(Beta+d))
                   - lgamma(*(Beta+d)) - lgamma(*n+*(Alpha+d)+*(Beta+d));

      *(log_fx+d) = lgamma(*n+*(Beta+d));

      /* Two terms were omitted in each of the two formulas above,
         since they will cancel out later (when those two terms are summed):
         lgamma(*(Alpha+d)) and lgamma(*n+1.0) */
    }
  }

  /* --- */

  for (x=0; x<=*n; x++)
  {
    for (d=0;d<2;d++)
    {
      *(myalpha+2*x+d) = *(alpha+d) + x;
      *(mybeta +2*x+d) = *(beta +d)+ *n - x;
    }
  }


  BetaHPD(&HPDLengthIsFixed, level, &mHPDLimits, myalpha, mybeta, NewtonRaphsonEpsilon, &returnHPDLimits, HPDLimits);

  i = 0;
  for (x=0; x<=*n; x += xstep)
  {
    for (d=0;d<2;d++)
    {
      *(lim0+d) = *(HPDLimits+i++);
      *(lim1+d) = *(HPDLimits+i++);
    }

    diff0 = fabs(*lim0 - *(lim0+1));
    diff1 = fabs(*lim1 - *(lim1+1));
    diff = diff1 > diff0 ? diff1 : diff0;

    if (*returnWorst == 1)
    {
      if (diff > *out) *out = diff;
    }
    else
    {
      for (d=0;d<D;d++)
      {
        /* Increment log_fx if x > 0 */;

        if (x > 0)
        {
          *(log_fx+d) += log(x + *(Alpha+d) - 1) - log(*n - x + *(Beta+d))
                       - log(x + 0.0) + log(*n - x + 1.0);
        }

        *(fx+d) = exp(*(lgamma0+d) + *(log_fx+d));
        *(fxtot+d) += *(fx+d);

        if (*returnProb == 1)
        {
          if (diff <= *AcceptedProbDiff) *(tmp_out+d) += *(fx+d);
        }
        else
        {
          *(tmp_out+d) += *(fx+d) * diff;
        }
      }
    }
  }


  /* ----- Retour de l'outcome indiqu dans 'out' ----------------------- */;


  if (*returnWorst == 0)
  {
    if (*use3)
    {
      *out = *tmp_out;
    }
    else if (*f0 >= 0.0)
    {
      *out = *f0 * *tmp_out + (1 - *f0) * *(tmp_out+1);
    }
    else
    {
      if (*returnProb == 0)
        *out = *tmp_out > *(tmp_out+1) ? *tmp_out : *(tmp_out+1);
      else
        *out = *tmp_out < *(tmp_out+1) ? *tmp_out : *(tmp_out+1);
    }

    for (d=0;d<D;d++)
    {
      if (*(fxtot+d) < ONE) *out *= -1, d = D;
    }
  }


  free(fx), free(fxtot), free(HPDLimits), free(lgamma0),
  free(lim0), free(lim1), free(log_fx),
  free(myalpha), free(mybeta), free(tmp_out),
  free(Alpha), free(Beta);
}


double fWorse(long todo, long lz, double *z, double *alpha, double *beta, long *n, long *x)
{
  long HPDLengthIsFixed = 0, mAlpha = 2, returnHPDLimits = 1;
  double *diffAlpha, *diffBeta, diffMean, diffVar, f = 0.0, *fElem, *mean, NewtonRaphsonEpsilon = 0.00000001, tmpf, *var;
  int k, s;

  /* C-code parms
     ------------
     mean: vector of length 4, in order gr1(specialist1 specialist2) gr2(specialist1 specialist2)
     var:  same as above
  */

  diffAlpha = (double *) malloc(2 * sizeof(double));
  diffBeta  = (double *) malloc(2 * sizeof(double));
  fElem     = (double *) malloc(4 * sizeof(double));
  mean      = (double *) malloc(4 * sizeof(double));
  var       = (double *) malloc(4 * sizeof(double));

  for (s=0;s<4;s++) *(mean+s) = *(var+s) = *(fElem+s) = 0.0;
  for (s=0;s<2;s++) *(diffAlpha+s) = *(diffBeta+s)= 0.0;


  /* Posterior moments */
  for (s=0;s<2;s++)
  {
    BetaMoments(mean+s, var+s, *(alpha+2*s)+*x, *(beta+2*s)+*n-*x);
    BetaMoments(mean+2+s, var+2+s, *(alpha+2*s+1)+*(x+1), *(beta+2*s+1)+*(n+1)-*(x+1));
  }

  /* *alpha: vector of length 4 < specialist1 (gr1 gr2) specialist2 (gr1 gr2) > */
  /* mean: vector of length 4, in order gr1(specialist1 specialist2) gr2(specialist1 specialist2) */

  /* Posterior parms */
  for (s=0;s<2;s++)
  {
    /* Compute (rescaled to 0/1 range) moments for the approx Beta distrn of the difference between the two proportions */
    diffMean = (*(mean+2+s) - *(mean+s) + 1)/2;
    diffVar = (*(var+s) + *(var+2+s))/4;

    BetaParmsFromMoments(diffAlpha+s, diffBeta+s, diffMean, diffVar);
  }


  if (todo == 0)
  {
    /* Compute HPD intervals */
    BetaHPD(&HPDLengthIsFixed, z, &mAlpha, diffAlpha, diffBeta, &NewtonRaphsonEpsilon, &returnHPDLimits, fElem);
    for (s=0;s<2;s++) *(fElem+s) = fabs(*(fElem+2+s)-*(fElem+s));
    f = *(fElem+1) > *fElem ? *(fElem+1) : *fElem;
  }
  else if (todo == 1)
  {
    /* Compute pbeta, loop over z (cumulative.comparison.points) */
    for (k=0;k<lz;k++)
    {
      for (s=0;s<2;s++) *(fElem+s) = pbeta(*(z+k), *(diffAlpha+s), *(diffBeta+s), 1, 1);
      tmpf = AbsLogDiff(*fElem, *(fElem+1));
      if (k == 0 || tmpf > f) f = tmpf;
    }
  }
  else
  {
    /* Compute qbeta, loop over z (quantiles) */
    for (k=0;k<lz;k++)
    {
      for (s=0;s<2;s++) *(fElem+s) = qbeta(*(z+k), *(diffAlpha+s), *(diffBeta+s), 1, 0);
      tmpf = fabs(*fElem - *(fElem+1));
      if (k == 0 || tmpf > f) f = tmpf;
    }
  }


  free(diffAlpha), free(diffBeta), free(fElem), free(mean), free(var);
  return(f);
}


void WorstOutcome(long *n, long *lz, double *z, double *alpha, double *beta, long *todo, double *out)
{
  int cont, *dir, direction, dirStep, foundWorse, iMobile = 0, k, looking4worse = 1, nConsec = 0;
  double f, fworse, *priorMean;
  long *x;


  /* Input parms
     -----------

    *todo = 0  compute HPD interval limits
          = 1  compute pbeta
          = 2  compute qbeta

    *alpha: vector of length 4 < specialist1 (gr1 gr2) specialist2 (gr1 gr2) >
    *beta:  as above

    *n : vector of length 2

    *z = level (todo=0)
         cumulative.comparison.points (todo=1)
         quantiles (todo=2)

    *lz = length of *z

    C-code parms
    ------------
    *priorMean: vector of length 4 < specialist1 (gr1 gr2) specialist2 (gr1 gr2) >
  */


  dir       = (int *)    malloc( 2 * sizeof(int));
  priorMean = (double *) malloc( 2 * sizeof(double));
  x         = (long *)   malloc( 2 * sizeof(long));

  *dir = *(dir+1) = -1;


  /* Re-scale problem parms */
  if (*todo == 1)
  {
    for (k=0;k<*lz;k++) *(z+k) = (1.0 + *(z+k))/2;
  }


  /* Compute initial f */

  if (*todo == 1)
  {
    /* Define initial values for *x, in the middle of prior means */
    for (k=0;k<4;k++) *(priorMean+k) = *(alpha+k) / (*(alpha+k) + *(beta+k));
    /* Now specialists avg prior means in each group */
    for (k=0;k<2;k++) *(priorMean+k) = (*(priorMean+k) + *(priorMean+k+2))/2;
    for (k=0;k<2;k++) *(x+k) = *(n+k) * *(priorMean+k);
  }
  else
  {
    *x = *(x+1) = 0;
  }

  fworse = fWorse(*todo, *lz, z, alpha, beta, n, x);


  while (looking4worse > 0)
  {
    iMobile = 1 - iMobile; /* alternate 0 <-> 1 */
    foundWorse = 0;
    dirStep = *(dir+iMobile) > 0 ? -2 : 2;

    for (direction=*(dir+iMobile); direction >= - 1 && direction <= 1 && foundWorse == 0; direction += dirStep)
    {
      cont = 1;

      while (cont)
      {
        if ((direction > 0 && *(x+iMobile) < *(n+iMobile)) || (direction < 0 && *(x+iMobile) > 0))
        {
          *(x+iMobile) += direction;

          /* Compute outcome */
          f = fWorse(*todo, *lz, z, alpha, beta, n, x);

          /* Keep above f value if worse than the worst seen so far */
          if (f > fworse)
          {
            foundWorse = 1;
            fworse = f;
            *(dir+iMobile) = direction;
          }
          else if (f < fworse)
          {
            cont = 0;
            *(x+iMobile) -= direction;
          }
        }
        else
        {
          cont = 0;
        }
      }
    }

    if (foundWorse == 0)
    {
      if (++nConsec == 2) looking4worse = 0;
    }
    else
    {
      nConsec = 0;
    }
  }


  /* Return outcome (re-scaled if necessary) */

  if (*todo == 0)
  {
    *out = 2 * fworse;
  }
  else if (*todo == 1)
  {
    *out = exp(fworse);
  }
  else
  {
    *out = 2 * fworse;
  }


  free(dir), free(priorMean);
}
