ss.cons.2norm.prob.cdf.bothmarg <-
function(cdf.points, accepted.cdf.diff, prior1, prior2,
                                                 prob=0.5, n2.n1.ratio=1, n.start=1000, n.max=100000, sim.size=50000,
                                                 max.cons.steps.same.dir=3)
{
  # prior1 and prior2 must be lists with dimensions mu0, n0, prec.shape and prec.rate
  tmp <- .ss.cons.2norm.check.list(prior1, "prior1")
  tmp <- .ss.cons.2norm.check.list(prior2, "prior2")
  

  out <- .ss.cons.2norm.cdf(cdf.points, accepted.cdf.diff, prior1, prior2,
                                                              sim.size, n.start, n.max,
                                                              return.prob=T, both=T, target=prob, n2.n1.ratio=n2.n1.ratio,
                                                              mcs=max.cons.steps.same.dir)

  out <- c(out, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff,
                     prior1=prior1, prior2=prior2, prob=prob,
                     n2.n1.ratio=n2.n1.ratio, n.start=n.start, n.max=n.max, sim.size=sim.size,
                     max.cons.steps.same.dir=max.cons.steps.same.dir, exact.results=F))
  
  return(out)
}
