ss.cons.2norm.prob.hpdlimits.bothmarg <-
function(accepted.diff, prior1, prior2, prob=0.5,
                                                 level=0.95, n2.n1.ratio=1, n.start=1000, n.max=100000, sim.size=50000,
                                                 max.cons.steps.same.dir=3)
{
  # prior1 and prior2 must be lists with dimensions mu0, n0, prec.shape and prec.rate
  tmp <- .ss.cons.2norm.check.list(prior1, "prior1")
  tmp <- .ss.cons.2norm.check.list(prior2, "prior2")

  tmp <- .ss.cons.2norm.known.sds(prior1, prior2)

  if (all(tmp$known))
  {
    out <- .ss.cons.2norm.hpdlimits.known.sds(tmp, accepted.diff, level=level, both=T, n2.n1.ratio=n2.n1.ratio,
              n.start=n.start, n.max=n.max, target=prob, compute.prob=T)
  
    out <- c(out, list(accepted.diff=accepted.diff, prior1=prior1, prior2=prior2, prob=prob,
                       level=level, n2.n1.ratio=n2.n1.ratio, n.start=n.start, n.max=n.max, exact.results=T))
  }
  else
  {
    out <- .ss.cons.2norm.hpdlimits(accepted.diff, prior1, prior2,
                                                                     level, sim.size, n.start, n.max,
                                                                     return.prob=T, both=T, target=prob, n2.n1.ratio=n2.n1.ratio, mcs=max.cons.steps.same.dir)

    out <- c(out, list(accepted.diff=accepted.diff, prior1=prior1, prior2=prior2, prob=prob,
                       level=level, n2.n1.ratio=n2.n1.ratio, n.start=n.start, n.max=n.max, sim.size=sim.size,
                       max.cons.steps.same.dir=max.cons.steps.same.dir, exact.results=F))
  }
  
  return(out)
}
