ss.plot <-
function(ss.out, zero=0.1, show.fit=T)
{
  log.n <- log(pmax(zero, ss.out$n.visited))
  n.plot <- pmax(exp(zero), ss.out$n.visited)
  out <- ss.out$outcome
  plot(n.plot, out, xlab='Sample Size', ylab='Outcome', xlog=T)

  if (show.fit)
  {
    df <- data.frame(out=out, log.n=log.n, log.n2 = log.n^2)
    glm.out <- glm(out~log.n+log.n2, data=df)
    log.n <- log(pmax(zero, par('usr')[c(1,2)]))
    log.n <- seq(from=log.n[1], to=log.n[2], length=300)
    df <- data.frame(log.n=log.n, log.n2=log.n^2)
    predict.out <- predict(glm.out, df)
    points(exp(log.n), predict.out, type='l', col='orange')
  }
}
