\name{ss.cons.2norm.prob.cdf.mymarg}
\alias{ss.cons.2norm.prob.cdf.mymarg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.cons.2norm.prob.cdf.mymarg(cdf.points, accepted.cdf.diff, prior1, prior2, clinical.prior, prob = 0.5, n2.n1.ratio = 1, n.start = 1000, n.max = 1e+05, sim.size = 50000, max.cons.steps.same.dir = 3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{cdf.points}{
One or more points at which the two cumultative posterior densities are to be compared.
}
  \item{accepted.cdf.diff}{
The accepted difference between the two cumultative posterior densities; any difference below this value is considered as meeting the consensus criterion.
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{clinical.prior}{
Clinical prior distribution parameters. The clinical prior is the prior used to generate the data used for subsequent updating of the prior distributions to be compared. (See \emph{Details} section.)
}
  \item{prob}{
The probability (in terms of the preposterior distribution of the data) with which the consensus criterion must be met.
}
  \item{n2.n1.ratio}{
The desired ratio of the sample sizes from the two groups. Default value is 1.
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
  \item{sim.size}{
The number of \bold{x} values to be sampled in order to assess consensus at each sample size visited in the march towards the optimal sample size.
}
  \item{max.cons.steps.same.dir}{
The Maximum number of Consecutive Steps allowed in the same direction in the march towards the optimal sample size, before the result for the next upper/lower bound is cross-checked. In our experience, max.cons.steps.same.dir = 3 is a good choice.
}
}
\details{
  The two prior distributions can have either common or different precisions (variances).  In either case, these precisions (variances) can be known or not.
  Each prior distribution (\code{prior1}, \code{prior2} and \code{clinical.prior}) must be specified through a multi-dimensional list as described below. Some dimensions are optional, depending on the context.
  \tabular{ll}{    \code{mu0} \tab The prior mean for each group.
      Numeric vector of length 2.\cr
    \code{n0} \tab The prior sample size equivalence from each group.
      Numeric vector of length 2.\cr
    \code{prec.shape} \tab Gamma shape parameter for the unknown precision within each group.
      Numeric vector of length 2.\cr
    \code{prec.rate} \tab Gamma rate parameter for unknown precision within each group.
      Numeric vector of length 2.\cr
    \code{common.sd} \tab Whether the (unknown) precisions are assumed to be the same in each groups (lambda_1 = lambda_2).
      Default is \code{False}.
      If true, then both \code{prec.shape} and \code{prec.rate} should be of length 1.
      It is not necessary to define \code{common.sd} when both precisions are known (see \code{known.sd} below).\cr
    \code{known.sd} \tab  Values for the standard deviation when the variance/precision is known.
      Optional.
      Numeric vector of length 1 or 2; can be of length 1 if only lambda_1 is known; \bold{must} be of length 2 if lambda_2 is known, in which case \code{known.sd[1]} needs to be set to \code{NA} if lambda_1 is unknown.
      If both precisions (lambda_1 and lambda_2) are known, then \code{prec.shape} and \code{prec.rate} are irrelevant (need not be defined).
      If only second group precision (lambda_2) is known, \code{prec.shape} and \code{prec.rate} can be of length 1 only.
      If only first group precision (lambda_1) is known, \code{prec.shape} and \code{prec.rate} need to be of length 2, but the first component in each of them will be ignored (can be set to \code{NA}s).
  }
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.2norm.prob.cdf}}, \code{\link{ss.cons.2norm.prob.cdf.bothmarg}},
   \code{\link{ss.cons.2norm.avg.cdf}}, \code{\link{ss.cons.2norm.avg.cdf.bothmarg}}, \code{\link{ss.cons.2norm.avg.cdf.mymarg}},
   \code{\link{ss.cons.2norm.prob.hpdlimits}}, \code{\link{ss.cons.2norm.prob.hpdlimits.bothmarg}},
   \code{\link{ss.cons.2norm.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.2norm.avg.hpdlimits}},
   \code{\link{ss.cons.2norm.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.2norm.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.2norm.prob.q}}, \code{\link{ss.cons.2norm.prob.q.bothmarg}},
   \code{\link{ss.cons.2norm.prob.q.mymarg}}, \code{\link{ss.cons.2norm.avg.q}},
   \code{\link{ss.cons.2norm.avg.q.bothmarg}}, \code{\link{ss.cons.2norm.avg.q.mymarg}}
}
\examples{
accepted.cdf.diff <- 0.01
cdf.points <- c(-1, 1)
clinical.prior     <- list(mu0=c(10, 10), n0=c(10, 9),  prec.shape=c(23, 25), prec.rate=c(2100, 2000))
prior1 <- list(mu0=c(15, 20), n0=c(25, 25), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
prior2    <- list(mu0=c(5, 6),   n0=c(25, 30), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
z <- ss.cons.2norm.prob.cdf.mymarg(cdf.points, accepted.cdf.diff, prior1, prior2, clinical.prior, prob=0.85)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
