\name{ss.cons.2norm.avg.hpdlimits}
\alias{ss.cons.2norm.avg.hpdlimits}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Some title
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
ss.cons.2norm.avg.hpdlimits(accepted.diff, prior1, prior2, prior1.mixture.wt = 0.5, level = 0.95, n2.n1.ratio = 1, n.start = 1000, n.max = 1e+05, sim.size = 50000, max.cons.steps.same.dir = 3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{accepted.diff}{
The accepted difference between the two specialists' HPD interval endpoints; any difference below that value is ruled as consensus.
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{prior1.mixture.wt}{
Clinical prior distibution --- used to generate the data --- is a mixture of the two prior distributions, with weight \emph{prior1.mixture.wt} assigned to \emph{prior1} and \emph{1-prior1.mixture.wt} to \emph{prior2}.
}
  \item{level}{
Coverage probability of the two HPD intervals.
}
  \item{n2.n1.ratio}{
The desired ratio of the sample sizes from the two groups. Default value is 1.
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
  \item{sim.size}{
The number of \bold{x} values to be sampled in order to assess consensus at each sample size visited in the march towards the optimal sample size.
}
  \item{max.cons.steps.same.dir}{
The Maximum number of Consecutive Steps allowed in the same direction in the march towards the optimal sample size, before the result for the next upper/lower bound is cross-checked. In our experience, max.cons.steps.same.dir = 3 is a good choice.
}
}
\details{
  The two prior distributions can have either common or different precisions (variances).  In either case, these precisions (variances) can be known or not.
  Each prior distribution (\code{prior1} and \code{prior2}) must be specified through a multi-dimensional list as described below. Some dimensions are optional, depending on the context.
  \tabular{ll}{    \code{mu0} \tab The prior mean for each group.
      Numeric vector of length 2.\cr
    \code{n0} \tab The prior sample size equivalence from each group.
      Numeric vector of length 2.\cr
    \code{prec.shape} \tab Gamma shape parameter for the unknown precision within each group.
      Numeric vector of length 2.\cr
    \code{prec.rate} \tab Gamma rate parameter for unknown precision within each group.
      Numeric vector of length 2.\cr
    \code{common.sd} \tab Whether the (unknown) precisions are assumed to be the same in each groups (lambda_1 = lambda_2).
      Default is \code{False}.
      If true, then both \code{prec.shape} and \code{prec.rate} should be of length 1.
      It is not necessary to define \code{common.sd} when both precisions are known (see \code{known.sd} below).\cr
    \code{known.sd} \tab  Values for the standard deviation when the variance/precision is known.
      Optional.
      Numeric vector of length 1 or 2; can be of length 1 if only lambda_1 is known; \bold{must} be of length 2 if lambda_2 is known, in which case \code{known.sd[1]} needs to be set to \code{NA} if lambda_1 is unknown.
      If both precisions (lambda_1 and lambda_2) are known, then \code{prec.shape} and \code{prec.rate} are irrelevant (need not be defined).
      If only second group precision (lambda_2) is known, \code{prec.shape} and \code{prec.rate} can be of length 1 only.
      If only first group precision (lambda_1) is known, \code{prec.shape} and \code{prec.rate} need to be of length 2, but the first component in each of them will be ignored (can be set to \code{NA}s).
  }
}
\value{
  This function returns a list consisting of the parameters listed below.
  \tabular{rl}{
    \code{n} \tab Optimal sample size.\cr
    \code{n.visited} \tab The list of visited sample sizes along the march towards optimal sample size.\cr
    \code{outcome} \tab The (estimated) outcome obtained for each visited sample size.\cr
    \code{exact.results} \tab Whether the optimal sample size \code{n} returned was obtained from exact calculations or simulation.\cr
    (other) \tab Function arguments as given at the function call.
  }
}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Consensus-Based Sample Size Calculations for Normal Means\cr
  The Journal, year;vol(issue):pp1-pp2.\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.2norm.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.2norm.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.2norm.prob.hpdlimits}}, \code{\link{ss.cons.2norm.prob.hpdlimits.bothmarg}},
   \code{\link{ss.cons.2norm.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.2norm.avg.cdf}}, \code{\link{ss.cons.2norm.avg.cdf.bothmarg}},
   \code{\link{ss.cons.2norm.avg.cdf.mymarg}}, \code{\link{ss.cons.2norm.prob.cdf}}, \code{\link{ss.cons.2norm.prob.cdf.bothmarg}},
   \code{\link{ss.cons.2norm.prob.cdf.mymarg}}, \code{\link{ss.cons.2norm.avg.q}}, \code{\link{ss.cons.2norm.avg.q.bothmarg}},
   \code{\link{ss.cons.2norm.avg.q.mymarg}}, \code{\link{ss.cons.2norm.prob.q}},
   \code{\link{ss.cons.2norm.prob.q.bothmarg}}, \code{\link{ss.cons.2norm.prob.q.mymarg}}
}
\examples{
accepted.diff <- 0.01
prior1 <- list(mu0=c(15, 20), n0=c(25, 25), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
prior2    <- list(mu0=c(5, 6),   n0=c(25, 30), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
z <- ss.cons.2norm.avg.hpdlimits(accepted.diff, prior1, prior2)
prior1 <- list(mu0=c(15, 20), n0=c(25, 25), known.sd=c(1, 1.2))
prior2    <- list(mu0=c(5, 6),   n0=c(25, 30), known.sd=c(1.1, 1.4))
z <- ss.cons.2norm.avg.hpdlimits(accepted.diff, prior1, prior2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
