\name{ss.plot}
\alias{ss.plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Some title
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
ss.plot(ss.out, zero = 0.1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ss.out}{
The output of a CBSS sample size function.
}
  \item{zero}{
An alternative value for \emph{n} in the plotting of \emph{log(n)} when \emph{n = 0}.
}
\item{show.fit}{
Whether or not a tentative fit curve will be displayed.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Consensus-Based Sample Size Calculations for Normal Means\cr
  The Journal, year;vol(issue):pp1-pp2.\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.cons.2norm.avg.q}}, \code{\link{ss.cons.2norm.avg.q.bothmarg}},
   \code{\link{ss.cons.2norm.avg.q.mymarg}}, \code{\link{ss.cons.2norm.prob.q}},
   \code{\link{ss.cons.2norm.prob.q.bothmarg}}, \code{\link{ss.cons.2norm.prob.q.mymarg}},
   \code{\link{ss.cons.2norm.avg.cdf}}, \code{\link{ss.cons.2norm.avg.cdf.bothmarg}}, \code{\link{ss.cons.2norm.avg.cdf.mymarg}},
   \code{\link{ss.cons.2norm.prob.cdf}}, \code{\link{ss.cons.2norm.prob.cdf.bothmarg}}, \code{\link{ss.cons.2norm.prob.cdf.mymarg}},
   \code{\link{ss.cons.2norm.avg.hpdlimits}}, \code{\link{ss.cons.2norm.avg.hpdlimits.bothmarg}},
   \code{\link{ss.cons.2norm.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.2norm.prob.hpdlimits}},
   \code{\link{ss.cons.2norm.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.2norm.prob.hpdlimits.mymarg}}
}
\examples{
accepted.diff <- 0.01
prior1 <- list(mu0=c(15, 20), n0=c(25, 25), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
prior2    <- list(mu0=c(5, 6),   n0=c(25, 30), prec.shape=c(23, 25), prec.rate=c(2100, 2000))
z <- ss.cons.2norm.avg.hpdlimits(accepted.diff, prior1, prior2)
prior1 <- list(mu0=c(15, 20), n0=c(25, 25), known.sd=c(1, 1.2))
prior2    <- list(mu0=c(5, 6),   n0=c(25, 30), known.sd=c(1.1, 1.4))
z <- ss.cons.2norm.avg.hpdlimits(accepted.diff, prior1, prior2)
ss.plot(z)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
