prop.prototype <-
function(len, alpha, beta, level=0.95, length.is.fixed=T, exact=TRUE, MBL=F, sim.size=1000, precision=1e-6, mcs=3, q=numeric(0))
{
  min.for.possible.return <- 2^ceiling(1.5*mcs)

  # If we always allow a return, there is a risk of making bad steps
  # when we are close to the answer.
  # Thus, we should not allow any return once some arbitrary 'step' (which is
  # 'min.for.possible.return') is reached.

  #vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
  #**************************************************************************
  # Define initial step
  # (as a function of any frequentist sample size estimate)

  step <- ceiling(log(prop.freq0(len,alpha,beta,level))/log(2))

  # Also define the threshold to cross for the quantity under study (the
  # length or the coverage probability of an HPD region)

  threshold <- ifelse(length.is.fixed, level, len)
  fixed.parm.target <- ifelse(length.is.fixed, len, level)

  # and define a factor, which is +/- 1, depending on if the quantity under
  # study is (almost) surely too large or too small when making no
  # observations [-1 if the quantity to measure is DEcreasing with n
  #               +1 if the quantity to measure is INcreasing with n]

  factor <- ifelse(length.is.fixed, 1, -1)

  #**************************************************************************
  #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

  quantity.to.measure <- ifelse(factor == +1,0,2*threshold)

  step <- 2^step

  history.ns <- numeric(0)
  history.steps <- numeric(0)
  history.out <- numeric(0)

  n <- 0

  max.cons.steps.same.dir <- mcs
  found.upper.bound <- FALSE
  possible.to.move.back <- !exact
  cons.steps.same.dir <- 0
  direction <- +1

  while(step>=1)
  {
    while(sign(factor*(threshold-quantity.to.measure)) == direction && step >= 1)
    {
      if (found.upper.bound) step <- max(1,step/2)
      if (step < min.for.possible.return && found.upper.bound) possible.to.move.back <- FALSE

      n <- n + direction*step

      cons.steps.same.dir <- cons.steps.same.dir+1

      history.ns <- c(n,history.ns)
      history.steps <- c(step*direction, history.steps)


      #vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
      #*******************************************************************************************************
      # Compute outcome of interest

      tmp <- prop.outcome(n, fixed.parm.target, alpha, beta, 
               length.is.fixed=length.is.fixed, MBL=MBL, exact=exact, sim.size=sim.size, precision=precision)
      
      if (length(q) == 0)
      {
        quantity.to.measure <- sum(tmp$out*tmp$f)
      }
      else if (q == 1)
      {
        quantity.to.measure <- min(tmp$out)
      }
      else
      {
        quantity.to.measure <- prop.covg.quantile(tmp, q)
      }
      
      history.out <- c(quantity.to.measure, history.out)

      #*******************************************************************************************************
      #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

      if(found.upper.bound &&
         cons.steps.same.dir == max.cons.steps.same.dir+1 &&
         possible.to.move.back)
      {

        if(sign(factor*(threshold-quantity.to.measure)) == direction)
        {
          # There was (most likely) a mistake, look for n's in the other direction
          at.n <- seq(along=history.ns)[history.ns == n]
          hs.an <- history.steps[at.n]

          step <- abs(hs.an[sign(hs.an) != direction][1])

          cons.steps.same.dir <- 0

          # and if there has never been a step coming from the other direction...
          if (is.na(step)) step <- max(abs(hs.an))
        }
        else
        {
          # There was (most likely) no mistake; keep looking around the same n's

          direction <- -direction
          cons.steps.same.dir <- 0
        }
      }

      if(found.upper.bound &&
         cons.steps.same.dir==max.cons.steps.same.dir &&
         sign(factor*(threshold-quantity.to.measure))==direction &&
         possible.to.move.back)
      {
        step <- 2*step
      }
      
      if (found.upper.bound && 
          sign(factor*(threshold-quantity.to.measure))==direction &&
          n==0)
      {
        step <- 0
      }
    }

    found.upper.bound <- TRUE

    direction <- -direction
    cons.steps.same.dir <- 0
    if (step == 1) step <- 0
  }

  if (n == 0) direction <- 0
  if (direction == +1) n <- n + 1

  out <- list(n=n, steps=list(n=history.ns, outcome=history.out), len=len, alpha=alpha, beta=beta, level=level, exact=exact, precision=precision, length.is.fixed=length.is.fixed, MBL=MBL)
  if (!exact)
  {
    out$sim.size <- sim.size
    out$mcs <- mcs
  }
  if (length(q) > 0) out$worst.level <- q

  return(out)
}
