\name{SampleSizeBinomial-package}
\alias{SampleSizeBinomial}
\docType{package}
\title{Bayesian sample size determination for a single binomial proportion}
\description{Calculate sample sizes based on highest posterior density intervals for a single binomial proportion using three different Bayesian approaches.}
\details{
\tabular{ll}{
Package: \tab SampleSizeBinomial\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2018-03-21\cr
License: \tab GLP (version 2 or later)\cr
URL: \tab \url{http://www.medicine.mcgill.ca/epidemiology/Joseph/Methodological-Publications-Bayesian-Sample-Size.html}\cr
}
A set of R functions for calculating sample size requirements using three different Bayesian criteria in the context of designing an experiment
to estimate a single binomial proportion. 
Functions for calculation of required sample sizes for the Average Length Criterion, 
the Average Coverage Criterion and the Worst Outcome Criterion 
in the context of binomial observations are provided.
Functions for both the fully Bayesian and the mixed Bayesian/likelihood approaches are provided.
\cr\cr See the related packages
\pkg{SampleSizeProportions} for Bayesian sample sizes calculations based on highest posterior density intervals for the difference between two binomial proportions 
(\url{http://cran.r-project.org/web/packages/SampleSizeProportions/index.html})
and \pkg{SampleSizeMeans} for Bayesian sample sizes calculations based on highest posterior density intervals for normal means 
(\url{http://cran.r-project.org/web/packages/SampleSizeMeans/index.html}).
}
\references{Lawrence Joseph, David B. Wolfson and Roxane du Berger\cr
Sample size calculations for binomial proportions via highest posterior density intervals\cr
The Statistician, 1995;44(2):143-154.\cr\cr
Joseph L, du Berger R, and Belisle P.\cr
Bayesian and mixed Bayesian/likelihood criteria for sample size determination\cr
Statistics in Medicine 1997;16(7):769-781.}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca}, David B. Wolfson, Roxane du Berger and Patrick Belisle}
\seealso{
  \code{\link{prop.acc}},
  \code{\link{prop.alc}},
  \code{\link{prop.modwoc}}, 
  \code{\link{prop.woc}}, 
  \code{\link{prop.mblacc}}, 
  \code{\link{prop.mblalc}}, 
  \code{\link{prop.mblmodwoc}}, 
  \code{\link{prop.mblwoc}},
  \code{\link{prop.plot}} 
}
\examples{
prop.acc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.alc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.woc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.modwoc(len=0.05, alpha=2, beta=1.5, level=0.95, worst.level=0.90)
prop.mblacc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.mblalc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.mblwoc(len=0.05, alpha=2, beta=1.5, level=0.95)
prop.mblmodwoc(len=0.05, alpha=2, beta=1.5, level=0.95, worst.level=0.90)
}
\keyword{design}
\concept{Bayesian sample size}
\concept{Binomial proportion}
