#include <R.h>
#include <Rmath.h>


double Delta(double lower, double upper, double alpha, double beta)
{
  double knum, lnum, lnum1, lnum2;
  double kdenom, ldenom, ldenom1, ldenom2, ldenom3, ldenom4;
  long sign = 1;

  if (lower > 0.0)
  {
    lnum1 = (alpha-1)*log(lower) + (beta-1)*log(1-lower);
    lnum2 = (alpha-1)*log(upper) + (beta-1)*log(1-upper);
    lnum = (lnum1 > lnum2) ? lnum1 : lnum2;
    knum = exp(lnum1-lnum) - exp(lnum2-lnum);
    if (knum < 0) sign = -1;
    lnum += log(fabs(knum));

    ldenom1 = log(fabs(alpha-1)) + (alpha-2)*log(upper) + (beta-1)*log(1-upper);
    ldenom2 = log(fabs(beta-1))  + (alpha-1)*log(upper) + (beta-2)*log(1-upper);
    ldenom3 = log(fabs(alpha-1)) + (alpha-2)*log(lower) + (beta-1)*log(1-lower);
    ldenom4 = log(fabs(beta-1))  + (alpha-1)*log(lower) + (beta-2)*log(1-lower);
    ldenom = (ldenom1 > ldenom2) ? ldenom1 : ldenom2;
    if (ldenom3 > ldenom) ldenom = ldenom3;
    if (ldenom4 > ldenom) ldenom = ldenom4;
    kdenom = exp(ldenom1-ldenom) - exp(ldenom2-ldenom) - exp(ldenom3-ldenom) + exp(ldenom4-ldenom);
    if (kdenom < 0.0) sign *= -1;
    ldenom += log(fabs(kdenom));

    if (alpha < 1.0) sign *= -1;
  }
  else
  {
    /* lower == 0.0 */;

    sign = -1;
    lnum = (alpha-1)*log(upper) + (beta-1)*log(1-upper);

    ldenom1 = log(alpha-1) + (alpha-2)*log(upper) + (beta-1)*log(1-upper);
    ldenom2 = log(beta-1)  + (alpha-1)*log(upper) + (beta-2)*log(1-upper);
    ldenom = (ldenom1 > ldenom2) ? ldenom1 : ldenom2;
    kdenom = exp(ldenom1-ldenom) - exp(ldenom2-ldenom);
    ldenom += log(fabs(kdenom));
    kdenom = (kdenom > 0.0) ? 1.0 : -1.0;

    if (alpha == 2.0)
    {
      if (ldenom < 0.0) ldenom = 0.0;
      kdenom -= exp(-ldenom);
      ldenom += log(fabs(kdenom));
    }

    if (kdenom < 0.0) sign *= -1;
  }

  return(sign * exp(lnum-ldenom));
}



void xMarginal(long n, double alpha, double beta, double *logfx)
{
  long i;
  double fx_sum, max_logfx = 0.0;

  for (i=0;i<=n;i++)
  {
    *(logfx+i) = lgamma(alpha + i) + lgamma(beta + n - i) - lgamma(i + 1.0) - lgamma(n - i + 1.0);

    if (i == 0)
    {
      max_logfx = *logfx;
    }
    else if (*(logfx+i) > max_logfx)
    {
      max_logfx = *(logfx+i);
    }
  }

  /* Standardize x marginal probabilities */;

  fx_sum = 0.0;

  for (i=0; i<=n;i++)
  {
    *(logfx+i) -= max_logfx;
    *(logfx+i) = exp(*(logfx+i));
    fx_sum += *(logfx+i);
  }

  for (i=0; i<=n;i++)
  {
    *(logfx+i) /= fx_sum;
  }
}



/* --------------------------------------------------------------------------------------------------

   Compute endpoints of a fixed length/coverage credible interval
   for a beta distribution

   -------------------------------------------------------------------------------------------------- */


void betaHPD(double *target, long LengthIsFixed, double alpha, double beta, double prec, double *res)
{
  double *x;
  double mode = (alpha-1)/(alpha+beta-2), pmode, delta, nextx, u;
  long i, side, found = 0;



  /* LengthIsFixed == 1 -> fixed length   (*target = length)
                   == 0 -> fixed coverage (*target = coverage) */;


  /* IMP: do not call this function with alpha = 1.0 or beta = 1.0
     (anyhow, c.i. is trivial in these cases) */;


  /* --- Memory allocation --- */;

  x = (double *) malloc(2 * sizeof(double));

  /* --- Initialize table vars --- */;

  for (i=0;i<2;i++) *(x+i) = 0.0;


  /* Start function */;

  if (alpha == 0.0 || beta == 0.0)
  {
    *target = LengthIsFixed ? 1.0 : 0.0;
    found = 1;
  }
  else if (alpha <= 1.0 && beta > 1.0)
  {
    if (LengthIsFixed)
    {
      *target = pbeta(*target, alpha, beta, 1, 0);
    }
    else
    {
      *target = qbeta(*target, alpha, beta, 1, 0);
    }

    found = 1;
  }
  else if (alpha > 1.0 && beta <= 1.0)
  {
    if (LengthIsFixed)
    {
      *target = pbeta(*target, beta, alpha, 1, 0);
    }
    else
    {
      *target = qbeta(*target, beta, alpha, 1, 0);
    }

    found = 1;
  }


  if (found == 0)
  {
    /* --- Find Newton-Raphson's starting point --- */;

    if (LengthIsFixed)
    {
      /* fixed length */;

      if (mode > *target)
      {
        *x = mode - *target;
      }
      else if (alpha < 1.0)
      {
        *x = (mode < (1-*target)) ? mode/2 : (1-*target)/2;
        while (dbeta(*x,alpha,beta,0) < dbeta(*x+*target, alpha, beta,0)) *x /= 2;
      }

      *(x+1) = (mode < (1-*target)) ? mode : (1-*target);
    }
    else
    {
      /* fixed coverage */;

      pmode = pbeta(mode, alpha, beta, 1, 0);

      if (pmode > *target)
      {
        *x = qbeta(pmode-*target, alpha, beta, 1, 0);
      }
      else if (alpha < 1.0)
      {
        *x = mode;
        while (pbeta(*x, alpha, beta, 1, 0) >= (1-*target)) *x /= 2;
        while (!found)
        {
          *x /= 2;
          u = qbeta(*target+pbeta(*x,alpha,beta,1,0), alpha, beta, 1, 0);
          if (dbeta(*x,alpha,beta,0) >= dbeta(u,alpha,beta,0)) found = 1;
        }
      }

      *(x+1) = ((1-pmode) < *target) ? qbeta(1-*target, alpha, beta, 1, 0) : mode;
    }


    /* --- Perform mixed Newton-Raphson/bisectional algorithm while |change| > prec  ---*/;


    nextx = (*x + *(x+1))/2; /* Starting point */;

    delta = prec + 1;
    while (fabs(delta) >= prec)
    {
      u = LengthIsFixed ? (nextx+*target) : qbeta(*target+pbeta(nextx,alpha,beta,1,0), alpha, beta, 1, 0);
      delta = Delta(nextx, u, alpha, beta);

      side = (delta > 0.0) ? 0 : 1;
      *(x+side) = nextx;

      if (fabs(delta) >= (*(x+1) - *x)) delta = (*(x+1-side) - *(x+side))/2;
      nextx = *(x+side) + delta;
    }


    /* Return credible interval endpoints */;

    *res = nextx;
    *(res+1) = LengthIsFixed ? (*res+*target) : qbeta(*target+pbeta(*res,alpha,beta,1,0), alpha, beta, 1, 0);

    /* and return length/coverage in *target */;

    if (LengthIsFixed)
    {
      for (i=0;i<2;i++) *(x+i) = pbeta(*(res+i), alpha, beta, 1, 1);
      *target = exp(*(x+1)) * (1-exp(*x-*(x+1)));
    }
    else
    {
      *target = *(res+1) - *res;
    }
  }

  free(x);
}


void OutcomeEstimation(long *n, double *target, long *LengthIsFixed, long *asMBL, double *alpha, double *beta, long *x, long *lx, double *out, double *fx, double *prec)
{
  double Target;
  double *res;
  long i;
  double post_alpha, post_beta;
  
  printf("allo\n");


  /* if this function is called with x of null length (length = 0),
       then it must be called with the arguments -out- & -fx- both of type double and length = *n + 1 to receive the marginal weights for each possible outcome;
     otherwise it must be called with the argument -out- (only) of type double and length = length(x)
  */;

  res = (double *) malloc(2 * sizeof(double));
  for (i=0;i<2;i++) *(res+i) = 0.0;


  if (*asMBL)
  {
    post_alpha = 1.0, post_beta = 1.0;
  }
  else
  {
    post_alpha = *alpha, post_beta = *beta;
  }

  if (*lx == 0)
  {
    /* Compute marginal weights */;
    xMarginal(*n, *alpha, *beta, fx);

    for (i=0;i<=*n;i++)
    {
      Target = *target;
      betaHPD(&Target, *LengthIsFixed, post_alpha + i, post_beta + *n - i, *prec, res);
      *(out+i) = Target;
    }
  }
  else
  {
    for (i=0;i<*lx;i++)
    {
      Target = *target;
      betaHPD(&Target, *LengthIsFixed, post_alpha + *(x+i), post_beta + *n - *(x+i), *prec, res);
      *(out+i) = Target;
    }
  }


  free(res);
}
