c**************************CONTENTS of baysmp.f******************************
c
c  BAYSMP   !g(n) for Average and Worst Outcome Criteria: AC, AL, WAC, WAL
c
c****************************************************************************
c
c Posterior Distribution according to methods:                 
c  1 (Average coverage)  ACC 
c  2 (Minimum coverage)  WOC
c  3 (Average length)    ALC
c  4 (Maximum length)    WOC (defunct)
c Calculation of Posterior probability, given sample size n      
c  Coverage CS, length w, beta parameters a and b   
c  and method met.               
c                       
c***************************************************************************
c
      FUNCTION BAYSMP(met,CS,w,a,b,n)

c     ..Parameters..
      integer          izero,ione
      double precision zero,half,one
      parameter       (izero=0,ione=1,zero=0.0d0,
     *                 half=0.50d0,one=1.0d0)

c     ..Arguments..
      integer          met,n                !method, sample size
      double precision BAYSMP,CS,w,a,b

c     ..Local..
      integer          j,nx
      double precision dn,bn,betln,a1,b1,dj,probln,sumpr,
     *                 x,differ,widx,widinit           

c     ..Calling function..
c     COVLEN                    !HPD coverage, HPD/non HPD length
      double precision GAMMLN              !log of Gamma function

c     ..INITIALIZE

      dn  = dble(n)                        !suggested sample size
      bn  = b + dn

c     ..AVERAGE METHODS CRITERIA 

      if ((met.eq.1).or.(met.eq.3)) then 

       betln =   GAMMLN(dn + one) + GAMMLN(a + b) 
     1         - GAMMLN(a) - GAMMLN(b) - GAMMLN(a + b + dn)

       sumpr = zero

       do 100 j = izero,n,ione              !begin average methods

        dj = dble(j)
        a1 = a  + dj
        b1 = bn - dj

        if (met.eq.ione) then                                 !ACC

c      ..HPD coverage differ at x given a1,b1 and w
         call COVLEN(1,a1,b1,w,CS,x,differ,widx,widinit)

        else                                                  !ALC

c      ..non HPD length widinit at point widx
c      ..HPD length differ at point x given initial length widinit
         call COVLEN(2,a1,b1,w,CS,widx,widinit,x,differ)

        endif                               !end average length

        probln =   GAMMLN(a1) + GAMMLN(b1) 
     1           - GAMMLN(dj + one) 
     2           - GAMMLN(dn - dj + one)   
     3           + log(differ) + betln
        sumpr  =   sumpr + exp(probln)

c     ..Break if average coverage > specified desired coverage
c     ..or break if average length > specified desired length

        if (met.eq.ione) then
         if (sumpr.gt.CS) GOTO 200
        else
         if (sumpr.gt.w)  GOTO 200
        endif

  100  continue                            !end average methods

  200  BAYSMP = sumpr

c     ..WORST OUTCOME CRITERIA

      else                               !worst outcome methods 

       nx = int(half*(dn+b-a))                    !mid position
       if (nx.gt.n) then
        j = n
       elseif (nx.le.izero) then
        j = izero
       else
        j = nx
       endif
       dj = dble(j)
       a1 = a  + dj
       b1 = bn - dj

       if (met.eq.2) then                                  !WAC

c      ..HPD coverage BAYSMP at x given a1,b1,w
        call COVLEN(1,a1,b1,w,CS,x,BAYSMP,widx,widinit)

       else                                                !WAL

c      ..non HPD length widinit at point widx
c      ..HPD length BAYSMP at point x given initial length widinit
        call COVLEN(2,a1,b1,w,CS,widx,widinit,x,BAYSMP)

       endif                                           !end WAL

      endif                          !end worst outcome methods

      RETURN
      END
c
c***************************************************************************
c
