c***********************CONTENTS OF headers.f****************************
c
c SCRNPRES            !Screen presentation     (READPAR)
c NAMETAG             !Print tags              (READPAR)
c KEY                 !Character input         (READPAR)
c OUTPUT1             !Message to be patient   (READPAR,INVBETA)
c OUTPUT2             !print parameter choices (READPAR)
c STP                 !Program abortion        (READPAR)
c SRCHINFO            !search status message   (BRACKN,FINDN,REFINE)
c HEADCOV             !header for COVER
c HEADCOV1            !header for min cov, max HPD/non HPD len  (HEADCOV)
c HEADCOV2            !header for max HPD leng, min cov         (HEADCOV)
c HEADCOV3            !header for Prob worst outcome            (HEADCOV)
c HSUBCOV             !sub header                     (HEADCOV1,HEADCOV2)
c
c************************************************************************
c
c Presentation to introduce programme
c
c************************************************************************
c
      SUBROUTINE SCRNPRES(line)

c     ..Arguments..
      character*75 line

c     ..Description of program

      write(6,'(/4x,a/)') line

      write(6,'(12x,2a)')     'This program calculates the sample size',
     *                                            ' requirements for a'
      write(6,'(14x,2a)')     'Binomial parameter using four different',
     *                                                      ' methods:'
      write(6,'(16x,2a)')             '1. Standard Normal Theory Based',
     *                                            ' Frequentist Method'
      write(6,'(16x,a)') '2. Bayesian Average Coverage Criterion (ACC)'
      write(6,'(16x,a)') '3. Bayesian Average Length   Criterion (ALC)'
      write(6,'(16x,a)') '4. Bayesian Worst   Outcome  Criterion (WOC)'

      write(6,'(//12x,2a)')      'This program also calculates minimum',
     *                                         ' possible HPD coverage'
      write(6,'(14x,2a)')          'probability and maximum HPD length',
     *                                         ' for each given sample'
      write(6,'(14x,2a)')          'size, as well as the pre-posterior',
     *                                        ' probability that these'
      write(6,'(14x,2a)')         'events will occur, according to the',
     *                                                  ' prior input.'


c     ..Authorship

      write(6,'(//12x,a)')            'These criteria are described in'
      write(6,'(14x,a)')    'Joseph, L., Wolfson, D. and du Berger, R.'
      write(6,'(14x,2a)')      '"Sample size calculations for binomial',
     *                                                   ' proportions'
      write(6,'(14x,a)')    'via highest posterior density intervals",'
      write(6,'(14x,a)')  'The Statistician, to appear in 1995, 44(2).'


c     ..Parameters
      write(6,'(//14x,a)')    'The following parameters must be input:'
      write(6,'(14x,2a)')       '- Beta prior parameters (a,b) for the',
     *                                           ' binomial parameter.'
      write(6,'(16x,a)')    'The mean of this distribution is a/(a+b),'
      write(6,'(16x,a)')   'and the variance is a*b/((a+b)^2*(a+b+1));'
      write(6,'(14x,a)')      '- The desired HPD coverage probability;'
      write(6,'(14x,a)')           '- The desired HPD interval length;'
      write(6,'(14x,2a)')       '- The point estimate for the binomial',
     *                                                     ' parameter'
      write(6,'(16x,a)')          '(used for frequentist method only).'

      write(6,'(/4x,a)') line

      RETURN
      END
c
c************************************************************************
c
c Tags to print for various parameters
c arg = 1 tag for beta prior parameters ; 
c arg = 2 tag for HPD coverage, length ;
c arg = 3 tag for frequentist method
c
c************************************************************************
c
      SUBROUTINE NAMETAG(arg,varname1,var1,varname2,var2)

c     ..Arguments..
      integer          arg
      character*20     varname1,varname2
      double precision var1,var2

      if (arg.eq.1) then
       write(6,'(//4x,2a,1x,f7.5)')         'The default values for',
     *                          ' the prior parameters are a =',var1
       write(6,'(6x,a,1x,f7.5,a)')                    'and b =',var2,
     *                         ', which give a uniform distribution'
      elseif (arg.eq.2) then
       write(6,'(//4x,2a)')        'The default value for ',varname1
       write(6,'(10x,a,1x,f7.5)')                        'is =',var1
      else
       write(6,'(//4x,2a)')        'The default value for the point',
     *                                   ' estimate of the binomial'
       write(6,'(6x,a,1x,f7.5,a)') 'parameter is a/(a+b) =',var1,','
       write(6,'(6x,a)')        'the mean of the prior distribution'
      endif

      RETURN
      END
c
c************************************************************************
c
c arg = 1 to confirm current parameter defaults (with argument plural)
c argument plural not required for following arguments
c  arg = 2 to confirm output type (screen or file)
c  arg = 3 to modify any or all parameters
c  arg = 4 to confirm all parameter defaults
c  arg = 5 for short or detailed output (not used here)
c
c************************************************************************
c
      FUNCTION KEY(arg,plural)

c     ..Arguments..
      integer       arg
      logical       plural

c     ..Local..
      character*3   KEY
      character*10  mess1
      character*12  mess2

      mess1 = 'this value'
      mess2 = 'these values'

      if (arg.eq.1) then
       if (plural) then
        write(6,'(/4x,3a)')     'Type <y><enter> to accept ',mess2,
     *                                    ', other <key> to MODIFY:'
       else
        write(6,'(/4x,3a)')      'Type <y><enter> to accept ',mess1,
     *                                    ', other <key> to MODIFY:'
       endif
       read(5,'(a)') KEY

      elseif (arg.eq.2) then
       write(6,'(/4x,2a)')             'Do you wish results output ',
     *                                          'to Screen or File?'
       write(6,'(/6x,2a)')            'Type <y><enter> for SCREEN, ',
     *                                       'other <key> for FILE:'
       read(5,'(a)') KEY

      elseif (arg.eq.3) then
       write(6,'(/4x,a)')                  'Modify which parameter?'
       write(6,'(/6x,a)')     'Type [<a><b><c><w><p>or<all>]<enter>'
       read(5,'(3a)') KEY

      elseif (arg.eq.4) then
       write(6,'(/4x,2a)') 'Type <y><enter> to CONFIRM, other <key>',
     *                           ' to further MODIFY any parameter:'
       read(5,'(a)') KEY

      else
       write(6,'(/4x,a)')    'Do you wish short or detailed output?'
       write(6,'(/6x,2a)')             'Type <y><enter> for SHORT, ',
     *                            'other <key> for DETAILED output:'
       read(5,'(a)') KEY
      endif

      RETURN
      END
c
c************************************************************************
c
c  Message to ask user to be patient
c  if arg = 1 general message to wait
c  if arg = 2 message from NEWTON RAPHSON failure (INVBETA)
c
c************************************************************************
c
      SUBROUTINE OUTPUT1(arg,line)

c     ..Arguments..
      integer       arg
      character*75  line

      if (arg.eq.1) then
       write(6,'(/4x,a)')   line      
       write(6,'(/10x,a)') 'The program may take a few minutes to run.'
       write(6,'(12x,2a)')         'Running time varies with the input',
     *                                                   ' parameters.'
      else
       write(6,'(/10x,a)')     'Solution to current criterion requires'
       write(6,'(12x,a)')   'procedures which slow down the algorithm.'
      endif
      write(6,'(16x,a//)')                       'Please be patient...'

      RETURN
      END
c
c************************************************************************
c
c     show user choice of parameters (called from READPAR)
c     arg = 1 print during interactive session
c     arg = 2 print only if file is required
c
c************************************************************************
c
      SUBROUTINE OUTPUT2(arg,a,b,CS,w,fp)

c     ..Arguments..
      integer          arg
      double precision a,b,CS,w,fp

      if (arg.eq.1) then
       write(6,'(/4x,a/)') 'You have chosen the following parameters:'
      else
       write(6,'(4x,a/)') 'Given the following user input:'
      endif

      write(6,'(6x,a,d17.11/)')  'Beta parameters:          a = ',a
      write(6,'(6x,a,d17.11/)')  '                          b = ',b
      write(6,'(6x,a,d17.11/)')  'HPD coverage probability  c = ',CS
      write(6,'(6x,a,d17.11/)')  'HPD interval length       w = ',w

      if (arg.eq.1)
     * write(6,'(6x,a,d17.11/)') 'Point estimate            p = ',fp

      RETURN
      END
c
c************************************************************************
c
c STOP from exhaustion
c
c************************************************************************
c
      SUBROUTINE STP()

      write(6,*)
      STOP '************Too many trials. Please restart'

      END
c
c************************************************************************
c
c   Output current status of program (from BRACKN,FINDN,REFINE)
c     long is for short or detailed output (defunct)
c     count is for step search number (particular to procedure)
c     nstat and fstat are status for sample size and function
c     na, nb are sample sizes
c     fna, fnb are functions evaluated at na, bn
c (94-06-20) : Use local counter to increase step number from
c   beginning to end of each method (ACC,ALC,WOC). This is done
c   with argument met. If met=1 reset locstep to zero. If
c   met=0 then increment locstep 
c
c************************************************************************
c
      SUBROUTINE SRCHINFO(long,count,nstat,fstat,na,nb,fna,fnb,met)

c     ..Parameters..
      integer          zero,one
      parameter       (zero=0,one=1)

c     ..Arguments..
      logical          long
      character*17     nstat,fstat
      integer          count,na,nb,met
      double precision fna,fnb

c     ..Local..
      integer          locstep,nbold
      save             locstep,nbold

      if (met.gt.zero) locstep = zero

      if (locstep.eq.zero) then 
       write(6,'(6x,a,1x,i3,1x,i14)') 'Step',locstep,nb
       locstep = locstep + one
       write(6,'(6x,a,1x,i3,1x,i14)') 'Step',locstep,na
       nbold = na
      else
       if (nbold.ne.nb) then
        write(6,'(6x,a,1x,i3,1x,i14)') 'Step',locstep,nb
        nbold = nb
       else
        locstep = locstep - one
       endif
      endif
      locstep = locstep + one
      
c     ..Useful for checks of bisection algorithm
c      write(6,'(6x,a,1x,i3,1x,a,2(1x,i14))') 'Step',count,nstat,na,nb
c      write(6,'(15x,a,2(1x,g14.7))') fstat,fna,fnb

      if (long) write(6,'(15x,a,2(1x,g14.7))') fstat,fna,fnb
      
      RETURN
      END
c
c************************************************************************
c
c  Heading for procedure COVER
c    arg  : Heading type (1-5) 
c           arg = 1 heading 1 for all methods
c           arg = 2 heading 2 for ACC,WOC
c           arg = 3 heading 3 for ACC,WOC
c           arg = 4 heading 2 for ALC
c           arg = 5 heading 4 for ACC,WOC, heading 3 for ALC
c    long : short or detailed output (ignore)
c    met : 1,2 coverage method (ACC,WOC); 3,4 length method (ALC)
c          (note: 4 defunct)
c    omegn : sample size for maximum coverage, minimum length
c    omeg  : log of probability of worst outcome
c    n   : sample size
c    a,b : beta prior parameters
c    wa,wb : beta parameter updates
c    nhpd,hpd : non HPD, HPD interval labels
c    lab1 : minimum, maximum character label
c    lab2 : coverage, length character label
c    lab3 : length, coverage character label
c    lab4 : maximum, minimum character label
c    cnt1, cnt2  : length w, coverage CS
c    xval   : position of optimal interval (x,x+w)
c    fxal   : maximum HPD length, minimum coverage
c    fxval1 : maximum non HPD length
c
c**********************************************************************
c
      SUBROUTINE HEADCOV(arg,long,met,omegn,omeg,n,a,b,wa,wb,
     *             nhpd,hpd,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)

c     ..Arguments..
      integer          arg,met,omegn,a,b,wa,wb
      double precision omeg,n,cnt1,cnt2,xval,xval1,fxval,fxval1
      logical          long
      character*10     nhpd,hpd,lab1,lab2,lab3,lab4

      if (arg.eq.1) then
        call HEADCOV1(long,met,n,a,b,wa,wb,hpd,lab1,lab2,lab3,
     *                                          cnt1,xval,fxval)
      elseif (arg.eq.2) then
       call HEADCOV2(met,n,nhpd,lab2,lab3,lab4,cnt2,xval,fxval)
      elseif (arg.eq.3) then
       call HEADCOV2(met,n,hpd,lab2,lab3,lab4,cnt2,xval1,fxval1)
      elseif (arg.eq.4) then
       call HEADCOV2(met,n,hpd,lab2,lab3,lab4,cnt2,xval,fxval)
      else
       call HEADCOV3(omegn,n,exp(omeg))
      endif

      RETURN
      END
c
c************************************************************************
c
c  Headings for procedure COVER
c    long : short or detailed output (ignore)
c    met : 1,2 coverage method (ACC,WOC); 3 length method (ALC)
c    n   : sample size
c    a,b : beta prior parameters
c    wa,wb : beta parameter updates
c    type : non HPD, HPD interval labels
c    lab1 : minimum, maximum
c    lab2 : coverage, length
c    lab3 : length, coverage
c    tag  : value of length, coverage
c    x    : position of optimal interval (x,x+w)
c    fx   : maximum length, minimum coverage
c
c**********************************************************************
c
      SUBROUTINE HEADCOV1(long,met,n,a,b,wa,wb,type,lab1,lab2,lab3,
     *                    tag,x,fx)

c     ..Arguments..
      integer          met,n
      double precision a,b,wa,wb,tag,fx,x
      logical          long
      character*10     type,lab1,lab2,lab3

c     ..Calling procedure..
c     HSUBCOV                                          !sub headings

c     ..OUTPUT

      if (long) then
       write(6,'(10x,2a,1x,g11.5)') 'Given prior Beta ',
     *                              'parameters a =',a
       write(6,'(38x,a,1x,g11.5)')             'b =',b
       write(6,'(12x,a,1x,g11.5)') 'Beta parameter updates   a1 =',wa
       write(6,'(37x,a,1x,g11.5)') 'b1 =',wb
      endif

      call HSUBCOV(1,n,x,tag)                  !sample size heading

      write(6,'(10x,a,1x,a7,a,a8,a,a8,1x,d11.5)')        'the',lab1,
     *                           ' HPD ',lab2,' of fixed ',lab3,tag
      write(6,'(10x,2a,1x,d17.11,a)')     'over all possible data',
     *                                          ' values is',fx,'.'

      if (met.le.2) then
       call HSUBCOV(2,n,x,tag)
      else
       call HSUBCOV(2,n,x,fx)
      endif

      RETURN
      END
c
c**********************************************************************
c
c  Heading for procedure COVER
c   met  : 1,2 : Coverage methods ; 3 : length method
c   n    : sample size
c   type : non HPD, HPD interval labels
c   lab1 : coverage,  length
c   lab2 : length,    coverage
c   lab3 : maximum,   minimum
c   tag  : fixed coverage, fixed length
c   x    : position of optimal coverage (x,x+w)
c   fx   : maximum length, minimum coverage
c
c**********************************************************************
c
      SUBROUTINE HEADCOV2(met,n,type,lab1,lab2,lab3,tag,x,fx)

c     ..Arguments..
      integer          met,n
      double precision tag,x,fx
      character*10     type,lab1,lab2,lab3

c     ..Local..
      integer          arg                 !for HPD or non HPD length
      character*22     mess1

c     ..Calling procedure..
c     HSUBCOV                                            !sub heading

      arg = 0

c     ..OUTPUT

      if (type.eq.'symmetric') then
       mess1='equal-tailed (non HPD)'
       arg = 1       
      else
       mess1='HPD'
      endif

      call HSUBCOV(1,n,x,fx)                     !sample size heading

            if (arg.eq.0) then
       write(6,'(10x,a,1x,a7,1x,a,1x,a8)') 'the',lab3,'HPD',lab2
      else
       write(6,'(10x,a,1x,a7,1x,a8)') 'the',lab3,lab2
      endif
      write(6,'(10x,a,1x,d17.11,1x,a)') 'required for',tag,mess1
      write(6,'(10x,a8,1x,a,1x,d17.11,a)') lab1,'is',fx,'.'

      if (met.le.2) then
       call HSUBCOV(2,n,x,fx)
      else
       call HSUBCOV(2,n,x,tag)
      endif

      RETURN
      END
c
c**********************************************************************
c
c  Heading for procedure COVER
c   worst outcome event nworst in ntrials trials 
c   with probability prob
c
c**********************************************************************
c
      SUBROUTINE HEADCOV3(nworst,ntrials,prob)

c     ..Arguments..
      integer          nworst,ntrials
      double precision prob

c     ..OUTPUT

      write(6,'(/8x,a,1x,i10,1x,a)') 'The event of',
     *      nworst,'successes'
      write(6,'(10x,a,1x,i10,1x,a)') 'in',ntrials,
     *     'trials occurs with'
      write(6,'(10x,2a,1x,d17.11,a)') 'prior',
     *     ' probability of', prob,'.'

      RETURN
      END
c
c**********************************************************************
c
c  Sub Heading for procedures HEADCOV1, HEADCOV2.
c  Prints interval values
c  arg = 1 print section 1 (sample size n)
c  arg = 2 print section 2
c
c**********************************************************************
c
      SUBROUTINE HSUBCOV(arg,n,x,w)

c     ..Arguments..
      integer          arg,n
      double precision x,w

c     ..OUTPUT

      if (arg.eq.1) then
       write(6,'(/8x,a,i10,a)') 'For a sample size of ',n,','
      else
       write(6,'(12x,2(a,d17.11),a)') 'This interval is (',
     *           x,', ',x+w,').'
      endif

      RETURN
      END
c
c**********************************************************************
c
