c**********************CONTENTS OF readpar.f**************************
c
c READPAR                                  !Read input parameters
c CHKPAR                                        !Parameter checks
c
c*********************************************************************
c
c Read parameters to calculate the sample size requirement
c  for a Binomial parameter using four different methods:
c   1) Standard Normal Theory Based Frequentist Method, 
c   2) Bayesian Average Coverage Criterion (ACC), 
c   3) Bayesian Average Length   Criterion (ALC), and
c   4) Bayesian Worst   Outcome  Criterion (WOC)
c  a,b are Beta prior parameters where mean = a/(a+b)
c  CS is HPD coverage, w is HPD length 
c   and fp is probability of success in binomial trial
c USER INPUT:
c..   A. READ AND CHECK PARAMETERS
c..      1    BETA PRIOR PARAMETER - a,b
c..      2.   HPD coverage probability
c..      3.   HPD interval length
c..      4.   FREQUENTIST PROBABILITY OF SUCCESS
c..   B. CONFIRM PARAMETERS TO USER
c..   C. DESIRED OUTPUT (screen or file)
c 1. beta parameters a,b >= 1 (default a,b = 1) 
c 2. hpd coverage  probability (default CS = 0.95)
c 3. hpd interval length  (default w = 0.1)
c 4. frequency probability of success (default mean of beta: a/(a+b))
c
c*********************************************************************
c
      SUBROUTINE READPAR(long,line,a,b,CS,w,fp)

c     ..Parameters..
      integer          LIM,izero,ione
      double precision TOL,one,defcs,defw
      parameter        (LIM=15,izero=0,ione=1,TOL=1.0d-06,
     *                  one=1.0d0,defcs=0.950d0,defw=0.10d0)

c     ..Arguments..
      double precision a,b,CS,w,fp
      character*75     line
      logical          long 

c     ..Local..
      integer          count,ocount
      character*3      inq
      character*20     taga,tagb,tagc,tagw,tagfp
      character*60     fileout
      logical          change

c     ..Calling Procedures..
c     SCRNPRES                                !screen presentation
c     NAMETAG                         !Parameters tagged for print
c     CHKPAR                                     !Parameter checks
c     OUTPUT1                                     !Message to wait
c     OUTPUT2                             !print parameter choices
      character*3       KEY                   !Character key input
c     STP                                           !Abort program

c     ..SCREEN PRESENTATION TO INTRODUCE PROGRAM

      call SCRNPRES(line)

c     ..INITIALIZATION

      ocount = izero
      change = .false.

c..   A. READ AND CHECK PARAMETERS

c..      1.  BETA PRIOR PARAMETERS - a,b

    5 a    = one                                 !present default
      taga = 'Beta a'
      b    = one                                 !present default
      tagb = 'Beta b'
      call NAMETAG(1,taga,a,tagb,b)
      inq  = KEY(1,.true.)

      if (inq.ne.'y') then                        !reject default
       count = izero
   10  call CHKPAR(1,izero,ione,one,LIM,TOL,count,taga,a,tagb,b)
       if (change) then
        fp = a/(a+b)
        GOTO 60
       endif
      endif

c..      2.   HPD COVERAGE

      CS   = defcs                               !present default
      tagc = 'HPD coverage'
      call NAMETAG(2,tagc,CS)
      inq  = KEY(1,.false.)

      if (inq.ne.'y') then                        !reject default
       count = izero
   30  call CHKPAR(2,izero,ione,one,LIM,TOL,count,tagc,CS)
       if (change) GOTO 60
      endif

c..      3.   HPD LENGTH

      w    = defw                                !present default
      tagw = 'HPD length'
      call NAMETAG(2,tagw,w)
      inq  = KEY(1,.false.)

      if (inq.ne.'y') then                        !reject default
       count = izero
   40  call CHKPAR(2,izero,ione,one,LIM,TOL,count,tagw,w)
       if (change) GOTO 60
      endif

c..      4.   FREQUENTIST PROBABILITY OF SUCCESS

      fp    = a/(a+b)                            !present default
      tagfp = 'Point estimate'
      call NAMETAG(3,tagfp,fp)
      inq   = KEY(1,.false.)

      if (inq.ne.'y') then                        !reject default
       count = izero
   50  call CHKPAR(2,izero,ione,one,LIM,TOL,count,tagfp,fp)
       if (change) GOTO 60
      endif

c..   B. CONFIRM PARAMETERS TO USER

   60 write(6,'(/4x,a)') line
      count = izero
      ocount = ocount + ione
      change=.false.

      call OUTPUT2(1,a,b,CS,w,fp)   !show user choice of parameters
      inq = KEY(4)

      if (inq.ne.'y') then
       change=.true.
       if (ocount.ge.LIM) call STP()
       inq = KEY(3)

       if (inq.eq.'a'.or.inq.eq.'b') GOTO 10
       if (inq.eq.'c')               GOTO 30
       if (inq.eq.'w')               GOTO 40  
       if (inq.eq.'p')               GOTO 50
       if (inq.eq.'all') then
        change=.false.
        write(6,'(/6x,a)') '**** Please re-input from beginning ****'
        GOTO 5
       endif

       if (inq.ne.'a'.and.inq.ne.'b'.and.inq.ne.'c'.and.
     *     inq.ne.'w'.and.inq.ne.'p'.and.inq.ne.'all') GOTO 60
      endif

c..   C. DESIRED OUTPUT

c      write(6,'(4x,a)') line                 !long or short version
c      long = .false.
c      inq = KEY(5)
c      if (inq.ne.'y') long = .true.

      write(6,'(4x,a)') line                  !file or screen output
      inq = KEY(2)

      if (inq.ne.'y') then
       write(6,'(/6x,2a)') 'Type name of FILE (e.g. "baysamp.siz") : '
       read(5,*) fileout
       call OUTPUT1(1,line)
       open(6,file=fileout)
       call OUTPUT2(2,a,b,CS,w)
      else
       call OUTPUT1(1,line)
       open(6,*)
      endif

      RETURN
      END
c 
c************************************************************************
c
c Some brief parameter checks (var=a,b,c,w,p)
c type is type of test (1 for beta(a,b),2 for c,w,p)
c izero,ione,one,lim,TOL are constants
c count is increment to abort program
c varname, var are variable name and variable (a,b,c,w,p)
c a,b are beta parameters; c is coverage; 
c w is length; p is prob of success
c
c************************************************************************
c
      SUBROUTINE CHKPAR(type,izero,ione,one,LIM,TOL,count,
     *                   varname1,var1,varname2,var2)

c     ..Arguments..
      integer          type,izero,ione,LIM,count
      double precision one, TOL, var1,var2
      character*20     varname1,varname2

c     ..Local..
      integer          i

c     ..Call Procedures
c     STP                                    !abort program

      write(6,'(2x,2a)')                   'Enter ',varname1
      if (type.gt.ione) then
   10  read(5,*,iostat=i) var1
      else
       write(6,'(4x,2a)')                    'and ',varname2
   20  read(5,*,iostat=i) var1,var2
      endif

      if (i.gt.izero) GOTO 90

      if (type.eq.ione) then
       if (var1.lt.one.or.var2.lt.one) GOTO 50
      else
       if (var1.lt.TOL.or.var1.gt.(one-TOL)) GOTO 50
      endif
      RETURN

   50 write(6,'(/4x,a)')            'Program is designed for:'
      if (type.eq.ione) then
       GOTO 60
      else
       GOTO 70
      endif

   60 write(6,'(6x,2a,d17.11)')          varname1, ' >= ',one
      write(6,'(8x,3a,d17.11)')    'and ',varname2,' >= ',one
      GOTO 90

   70 write(6,'(6x,d17.11,3a,d17.11)')             TOL,' <= ',
     *                                varname1,' <= ',one-TOL

   90 count = count + ione
      if (count.ge.LIM) call STP()
      write(6,'(/4x,2a)')       'Invalid entry for ',varname1
      if (type.eq.ione) write(6,'(6x,2a)') 'and/or ',varname2
      write(6,'(6x,a)') 'Please re-input...'
      if (type.gt.ione) GOTO 10
      GOTO 20

      END
c
c************************************************************************
c
