c**************************MEAN BETA DENSITY***********************
c
c Subroutines to help in Splus beta density graphics
c Construction of mean beta density over domain vector 
c x (0<x<1), given beta parameter vectors a,b
c OUTPUT is: mean beta density dens
c
c 1. for i=1,m     (parameter elements)
c     for j = 1,n  (domain elements)
c      dens(j) = dens(j) + dbeta(ai,bi,xj)
c     end for j
c    end for i
c 2. for j = 1,n 
c      dens(j) = dens(j)/m  !mean beta density
c
c******************************************************************
c
c      Main subroutine
c
c******************************************************************
c
      SUBROUTINE postbet(m,n,dens,x,a,b)

c     ..Arguments..
      integer          m,n
      double precision dens(n),x(n),a(m),b(m)

c     ..Local..
      integer          i,j
      double precision betln,aa,bb

c     ..Calling procedures..
      double precision LBETAF
      double precision DBETA

      do 100 j = 1,n
       dens(j) = 0.0d0
  100 continue

      do 300 i = 1,m
       aa = a(i)
       bb = b(i)
       betln = LBETAF(aa,bb)
       aa = aa - 1.0d0
       bb = bb - 1.0d0
       do 200 j = 1,n
        dens(j) = dens(j) + DBETA(x(j),aa,bb,betln)
  200  continue
  300 continue

      do 400 j = 1,n
       dens(j) = dens(j)/dble(m)
  400 continue

      RETURN
      END
c
c******************************************************************
c
c     BETA density f(x|a,b)
c
c******************************************************************
c
      FUNCTION DBETA(x,a,b,betln)

c     ..Arguments..
      double precision DBETA,x,a,b,betln

      DBETA = exp(a*log(x) + b*log(1.0d0-x) - betln)

      RETURN
      END
c
c******************************************************************
c
c     LOG of beta function for beta density
c
c******************************************************************
c
      FUNCTION LBETAF(a,b)

c     ..Arguments..
      double precision LBETAF,a,b

c     ..Calling functions
      double precision GAMMLN

      LBETAF = GAMMLN(a) + GAMMLN(b) - GAMMLN(a+b)

      RETURN
      END
c
c******************************************************************
c
c     Presss et al. (1990) Numerical recipes : 
c     log of gamma function, xx>0 
c
c******************************************************************
c
      FUNCTION GAMMLN(xx)

c     ..Arguments..
      double precision GAMMLN,xx

c     ..Local..
      integer          j 
      double precision cof(6),stp,half,one,fpf,x,tmp,ser

      DATA cof,stp/76.18009173D0,-86.50532033D0,24.01409822D0,
     *               -1.231739516D0,.120858003D-2,-.536382D-5,
     *               2.50662827465D0/

      DATA half,one,fpf/0.5D0,1.0D0,5.5D0/

      x   = xx - one
      tmp = x + fpf
      tmp = (x+half) * log(tmp) - tmp
      ser = one
      do 11 j=1,6
        x   = x + one
        ser = ser + cof(j)/x
11    continue

      GAMMLN= tmp + log(stp*ser)

      RETURN
      END
c
c******************************************************************
c
