c***************************CONTENTS********************************
c
c        UPDATDIR  : Dirichlet updates
c        UPDATGAM  : Gamma updates   
c        UPDATMEAN : mean of X(i,n) of size tau(i) and n-tau(i)
c        UPDATNORM : normal updates
c
c*******************************************************************
c
c      Update dirichlet parameters
c       tau(m) : Column position j=jd+1 to n,jd>=0,<n row i
c                (obtained from posterior distribution)
c       alp(n) : Initial vector of n Dirichlet parameters 
c      nalp(n) : Updated Dirichlet parameter vector
c
c*******************************************************************
c
      SUBROUTINE UPDATDIR(m,n,jd,tau,alp,nalp)

c     ..Scalar arguments..
      integer          m,n,jd

c     ..Array arguments..
      integer          tau(m)
      double precision alp(n),nalp(n)

c     ..Local scalars..
      integer          i,j,itau,jds

      jds = jd+1

      do 10 j = jds,n                     !Initialize alpha update
       nalp(j) = alp(j)
   10 continue

      do 40 i = 1,m                   !Update Dirichlet parameters
       itau = tau(i)
       do 20 j = jds,n
        if (itau.eq.j) GOTO 30
   20  continue
   30  nalp(j) = nalp(j) + 1.0d0
   40 continue

      RETURN
      END
c
c****************************************************************
c
c     Update Gamma parameters 
c      (slight modification of De Groot formula)
c        Set X~Gamma(a,b),E(X)=a*b instead of a/b.
c        Ultimately we make small change to nb values.
c      X(m,n)  : real data matrix
c      mu(m,2) : Initial mean vectors
c      a,b,    : Initial Gamma parameters
c      tau(m)  : Column position j=jd+1 to n,jd>=0,<n row 
c      na,nb   : Updated Gamma parameters na and nb 
c
c****************************************************************
c
      SUBROUTINE UPDATGAM(m,n,nvar,X,omega,mu,tau,meantx,
     *                    a,b,na,nb)

c     ..Parameters..
      double precision half,zero,one
      parameter       (half=0.5d0,zero=0.0d0,one=1.0d0)

c     ..Scalar arguments..
      integer          m,n

c     ..Array arguments..
      integer          tau(m),nvar(m)
      double precision X(m,n),mu(m,2),omega(2),meantx(m,2),
     *                 a(m,2),b(m,2),na(m,2),nb(m,2)

c     ..Local scalars..
      integer          i,j,itau,nv
      double precision NUM,DEN,sum,ssq

      do 30 i = 1,m                        !for each row i of X

       itau = tau(i)
       nv   = nvar(i)

       na(i,1) = a(i,1) + half*itau                         !a1'
       na(i,2) = a(i,2) + half*(nv-itau)                    !a2'

       NUM = omega(1)*itau*(meantx(i,1)-mu(i,1))*
     +       (meantx(i,1)-mu(i,1))
       DEN = omega(1)+itau
       sum = zero
       ssq = zero

       do 10 j = 1,itau                     !Sum row X to tau(i)
        sum = sum + X(i,j)
        ssq = ssq + X(i,j)*X(i,j)
   10  continue
       ssq = ssq - sum*sum/itau
       nb(i,1) = one/b(i,1) + half*(ssq + NUM/DEN)           !b1'
       nb(i,1) = one/nb(i,1)           !modification of De Groot

       if (nv.gt.itau) then
        NUM = omega(2)*(nv-itau)*(meantx(i,2) - mu(i,2))*
     +        (meantx(i,2) - mu(i,2))
        DEN = omega(2) + nv - itau
        sum = zero
        ssq = zero

        do 20 j = itau+1,nv           !Sum tau(i) of X to nvar(i)
         sum = sum + X(i,j)
         ssq = ssq + X(i,j)*X(i,j)
   20   continue
        sum = sum*sum
        ssq = ssq - sum/(nv-itau)
        nb(i,2) = one/b(i,2) + half*(ssq + NUM/DEN)          !b2'
        nb(i,2) = one/nb(i,2)           !modification of De Groot

       else

        nb(i,2) = b(i,2)

       endif

   30 continue                               !for each row i=1,m

      RETURN
      END
c
c*******************************************************************
c
c compute mean update to tau(i). This is required for
c  UPDATNORM and UPDATGAM
c
c*******************************************************************
c
      SUBROUTINE UPDATMEAN(m,n,nvar,X,tau,meantx)

c     ..Scalar arguments..
      integer          m,n

c     ..Array arguments..
      integer          tau(m),nvar(m)
      double precision X(m,n),meantx(m,2)
      
c     ..Local..
      integer          i,j,itau,nv
      double precision sum

      do 30 i = 1,m                                 !for each row i
       itau = tau(i)
       nv   = nvar(i)
       sum  = 0.0d0

       do 10 j = 1,itau                         !for distribution 1
        sum = sum + X(i,j)
   10  continue
       meantx(i,1) = sum/dble(itau)
       sum = 0.0d0

       do 20 j = itau+1,nv                      !for distribution 2
        sum = sum + X(i,j)
   20  continue

       if(nv.gt.itau) then
        meantx(i,2) = sum/dble(nv-itau)
       else
        meantx(i,2) = 0.0d0
       endif

   30 continue                                  !for each row i=1,m

      RETURN
      END
c
c********************************************************************
c
c Update mean and variance according to tau(i) obtained
c from Posterior distribution i=1,m rows
c
c********************************************************************
c
      SUBROUTINE UPDATNORM(m,n,nvar,omega,R,mu,tau,
     *                     meantx,updatmu,updatsig)

c     ..Scalar arguments..
      integer          m,n

c     ..Array arguments..
      integer          nvar(m),tau(m)
      double precision omega(2),mu(m,2),R(m,2),meantx(m,2),
     *                 updatmu(m,2),updatsig(m,2)

c     ..Local scalars..
      integer          i,itau,nv
      double precision NUM,DEN

      do 100 i = 1,m                            !for each row i=1,m

       itau = tau(i)
       nv   = nvar(i)

       NUM = omega(1)*mu(i,1) + itau*meantx(i,1)        !for dist 1
       DEN = omega(1)         + itau

       updatmu(i,1)    = NUM/DEN
       updatsig(i,1)   = 1.0d0/(DEN*R(i,1))


       NUM = omega(2)*mu(i,2) + (nv - itau)*meantx(i,2) !for dist 2
       DEN = omega(2)         +  nv - itau

       updatmu(i,2)    = NUM/DEN
       updatsig(i,2)   = 1.0d0/(DEN*R(i,2))

  100 continue                                  !for each row i=1,m

      RETURN
      END
c
c********************************************************************
c
